/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.ListService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.vault.LoadingVaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import ch.cyberduck.core.vault.registry.VaultRegistryAclPermissionFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryAttributesFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryBulkFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryCompressFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryCopyFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryDeleteFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryDirectoryFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryDownloadFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryEncryptionFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryFindFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryHeadersFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryIdProvider;
import ch.cyberduck.core.vault.registry.VaultRegistryLifecycleFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryListService;
import ch.cyberduck.core.vault.registry.VaultRegistryLocationFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryLockFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryLoggingFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryMoveFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryMultipartWriteFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryReadFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryRedundancyFeature;
import ch.cyberduck.core.vault.registry.VaultRegistrySearchFeature;
import ch.cyberduck.core.vault.registry.VaultRegistrySymlinkFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryTimestampFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryTouchFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryTransferAccelerationFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryUnixPermissionFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryUploadFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryUrlProvider;
import ch.cyberduck.core.vault.registry.VaultRegistryVersioningFeature;
import ch.cyberduck.core.vault.registry.VaultRegistryWriteFeature;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class DefaultVaultRegistry
extends CopyOnWriteArraySet<Vault>
implements VaultRegistry {
    private static final Logger log = Logger.getLogger(DefaultVaultRegistry.class);
    public static final String DEFAULT_MASTERKEY_FILE_NAME = "masterkey.cryptomator";
    public static final String DEFAULT_BACKUPKEY_FILE_NAME = "masterkey.cryptomator.bkup";
    public static final byte[] DEFAULT_PEPPER = new byte[0];
    private final Preferences preferences = PreferencesFactory.get();
    private final PasswordStore keychain;
    private final PasswordCallback prompt;

    public DefaultVaultRegistry(PasswordCallback prompt) {
        this(PasswordStoreFactory.get(), prompt);
    }

    public DefaultVaultRegistry(PasswordStore keychain, PasswordCallback prompt) {
        this.keychain = keychain;
        this.prompt = prompt;
    }

    public DefaultVaultRegistry(PasswordStore keychain, PasswordCallback prompt, Vault ... vaults) {
        super(Arrays.asList(vaults));
        this.keychain = keychain;
        this.prompt = prompt;
    }

    @Override
    public boolean add(Vault vault) {
        return super.add(vault);
    }

    @Override
    public boolean close(Path directory) {
        return this.removeIf(vault -> {
            if (new SimplePathPredicate(vault.getHome()).test(directory)) {
                vault.close();
                directory.attributes().setVault(null);
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean contains(Path directory) {
        for (Vault vault : this) {
            if (directory.equals(vault.getHome())) {
                return true;
            }
            if (!directory.isChild(vault.getHome())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Close %d registered vaults", this.size()));
        }
        this.forEach(Vault::close);
        super.clear();
    }

    @Override
    public Vault find(Session session, Path file) throws VaultUnlockCancelException {
        return this.find(session, file, true);
    }

    public Vault find(Session session, Path file, boolean lookup) throws VaultUnlockCancelException {
        for (Vault vault : this) {
            if (!vault.contains(file)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found vault %s for file %s", vault, file));
            }
            return vault;
        }
        if (lookup) {
            LoadingVaultLookupListener listener = new LoadingVaultLookupListener(this, this.keychain, this.prompt);
            if (file.attributes().getVault() != null) {
                return listener.load(session, file.attributes().getVault(), DEFAULT_MASTERKEY_FILE_NAME, DEFAULT_PEPPER);
            }
            Path directory = file.getParent();
            if (directory.attributes().getVault() != null) {
                return listener.load(session, directory.attributes().getVault(), DEFAULT_MASTERKEY_FILE_NAME, DEFAULT_PEPPER);
            }
        }
        return Vault.DISABLED;
    }

    @Override
    public <T> T getFeature(Session<?> session, Class<T> type, T proxy) {
        if (null == proxy) {
            return null;
        }
        if (type == ListService.class) {
            return (T)new VaultRegistryListService(session, (ListService)proxy, this, new LoadingVaultLookupListener(this, this.keychain, this.prompt)).withAutodetect(this.preferences.getBoolean("cryptomator.vault.autodetect"));
        }
        if (type == Find.class) {
            return (T)new VaultRegistryFindFeature(session, (Find)proxy, this, new LoadingVaultLookupListener(this, this.keychain, this.prompt)).withAutodetect(this.preferences.getBoolean("cryptomator.vault.autodetect"));
        }
        if (type == Bulk.class) {
            return (T)new VaultRegistryBulkFeature(session, (Bulk)proxy, this);
        }
        if (type == Touch.class) {
            return (T)new VaultRegistryTouchFeature(session, (Touch)proxy, this);
        }
        if (type == Directory.class) {
            return (T)new VaultRegistryDirectoryFeature(session, (Directory)proxy, this);
        }
        if (type == Upload.class) {
            return (T)new VaultRegistryUploadFeature(session, (Upload)proxy, this);
        }
        if (type == Download.class) {
            return (T)new VaultRegistryDownloadFeature(session, (Download)proxy, this);
        }
        if (type == Read.class) {
            return (T)new VaultRegistryReadFeature(session, (Read)proxy, this);
        }
        if (type == Write.class) {
            return (T)new VaultRegistryWriteFeature(session, (Write)proxy, this);
        }
        if (type == MultipartWrite.class) {
            return (T)new VaultRegistryMultipartWriteFeature(session, (MultipartWrite)proxy, this);
        }
        if (type == Move.class) {
            return (T)new VaultRegistryMoveFeature(session, (Move)proxy, this);
        }
        if (type == AttributesFinder.class) {
            return (T)new VaultRegistryAttributesFeature(session, (AttributesFinder)proxy, this);
        }
        if (type == UrlProvider.class) {
            return (T)new VaultRegistryUrlProvider(session, (UrlProvider)proxy, this);
        }
        if (type == IdProvider.class) {
            return (T)new VaultRegistryIdProvider(session, (IdProvider)proxy, this);
        }
        if (type == Delete.class) {
            return (T)new VaultRegistryDeleteFeature(session, (Delete)proxy, this);
        }
        if (type == Symlink.class) {
            return (T)new VaultRegistrySymlinkFeature(session, (Symlink)proxy, this);
        }
        if (type == Headers.class) {
            return (T)new VaultRegistryHeadersFeature(session, (Headers)proxy, this);
        }
        if (type == Compress.class) {
            return (T)new VaultRegistryCompressFeature(session, (Compress)proxy, this);
        }
        if (type == UnixPermission.class) {
            return (T)new VaultRegistryUnixPermissionFeature(session, (UnixPermission)proxy, this);
        }
        if (type == AclPermission.class) {
            return (T)new VaultRegistryAclPermissionFeature(session, (AclPermission)proxy, this);
        }
        if (type == Copy.class) {
            return (T)new VaultRegistryCopyFeature(session, (Copy)proxy, this);
        }
        if (type == Timestamp.class) {
            return (T)new VaultRegistryTimestampFeature(session, (Timestamp)proxy, this);
        }
        if (type == Encryption.class) {
            return (T)new VaultRegistryEncryptionFeature(session, (Encryption)proxy, this);
        }
        if (type == Lifecycle.class) {
            return (T)new VaultRegistryLifecycleFeature(session, (Lifecycle)proxy, this);
        }
        if (type == Location.class) {
            return (T)new VaultRegistryLocationFeature(session, (Location)proxy, this);
        }
        if (type == Lock.class) {
            return (T)new VaultRegistryLockFeature(session, (Lock)proxy, this);
        }
        if (type == Logging.class) {
            return (T)new VaultRegistryLoggingFeature(session, (Logging)proxy, this);
        }
        if (type == Redundancy.class) {
            return (T)new VaultRegistryRedundancyFeature(session, (Redundancy)proxy, this);
        }
        if (type == Search.class) {
            return (T)new VaultRegistrySearchFeature(session, (Search)proxy, this);
        }
        if (type == TransferAcceleration.class) {
            return (T)new VaultRegistryTransferAccelerationFeature(session, (TransferAcceleration)proxy, this);
        }
        if (type == Versioning.class) {
            return (T)new VaultRegistryVersioningFeature(session, (Versioning)proxy, this);
        }
        return proxy;
    }
}

