/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.KeychainLoginService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyHostUrlProvider;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import org.apache.log4j.Logger;

public abstract class SessionBackgroundAction<T>
extends AbstractBackgroundAction<T>
implements ProgressListener,
TranscriptListener {
    private static final Logger log = Logger.getLogger(SessionBackgroundAction.class);
    private boolean failed;
    private StringBuffer transcript = new StringBuffer();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final AlertCallback alert;
    private final LoginCallback login;
    private final ProgressListener progress;
    protected final SessionPool pool;

    public SessionBackgroundAction(SessionPool pool, AlertCallback alert, LoginCallback login, ProgressListener progress) {
        this.pool = pool;
        this.alert = alert;
        this.login = login;
        this.progress = progress;
    }

    @Override
    public void message(String message) {
        this.progress.message(message);
    }

    @Override
    public void log(TranscriptListener.Type request, String message) {
        this.transcript.append(message).append(LINE_SEPARATOR);
    }

    @Override
    public void prepare() {
        super.prepare();
        this.message(this.getActivity());
    }

    protected void reset() throws BackgroundException {
        this.failed = false;
    }

    public boolean hasFailed() {
        return this.failed;
    }

    @Override
    public T call() throws BackgroundException {
        try {
            return new DefaultRetryCallable(this.pool.getHost(), new BackgroundExceptionCallable<T>(){

                @Override
                public T call() throws BackgroundException {
                    SessionBackgroundAction.this.reset();
                    return SessionBackgroundAction.this.run();
                }
            }, this, this).call();
        }
        catch (ConnectionCanceledException e) {
            throw e;
        }
        catch (BackgroundException e) {
            this.failed = true;
            throw e;
        }
    }

    @Override
    public T run() throws BackgroundException {
        Session<?> session = this.pool.borrow(this).withListener(this);
        BackgroundException failure = null;
        try {
            T t = this.run(session);
            return t;
        }
        catch (LoginFailureException e) {
            if (PreferencesFactory.get().getBoolean("connection.retry.login.enable")) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Prompt to re-authenticate for failure %s", e));
                }
                if (this.login(session, e)) {
                    T t = this.run();
                    return t;
                }
            } else {
                log.warn((Object)String.format("Disabled retry for login failure %s", e));
            }
            failure = e;
            throw e;
        }
        catch (BackgroundException e) {
            failure = e;
            throw e;
        }
        finally {
            this.pool.release(session.removeListener(this), failure);
        }
    }

    protected boolean login(Session<?> session, LoginFailureException e) {
        Host bookmark = this.pool.getHost();
        try {
            KeychainLoginService service = new KeychainLoginService(PasswordStoreFactory.get());
            StringAppender details = new StringAppender();
            details.append(LocaleFactory.localizedString("Login failed", "Credentials"));
            details.append(e.getDetail());
            if (service.prompt(bookmark, details.toString(), this.login, new LoginOptions(bookmark.getProtocol()))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Re-authenticate with credentials %s", bookmark.getCredentials()));
                }
                service.authenticate(ProxyFactory.get().find(new ProxyHostUrlProvider().get(bookmark)), session, this.progress, this.login, new CancelCallback(){

                    @Override
                    public void verify() throws ConnectionCanceledException {
                        if (SessionBackgroundAction.this.isCanceled()) {
                            throw new ConnectionCanceledException();
                        }
                    }
                });
                return true;
            }
        }
        catch (BackgroundException f) {
            log.warn((Object)String.format("Ignore error %s after login failure %s ", f, e));
        }
        return false;
    }

    public abstract T run(Session<?> var1) throws BackgroundException;

    @Override
    public boolean alert(BackgroundException failure) {
        if (this.isCanceled()) {
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Run alert callback %s for failure %s", this.alert, failure));
        }
        return this.alert.alert(this.pool.getHost(), failure, new StringBuilder(this.transcript.toString()));
    }

    @Override
    public void cleanup() {
        this.transcript.setLength(0);
        this.message("");
    }

    @Override
    public String getName() {
        return BookmarkNameProvider.toString(this.pool.getHost());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SessionBackgroundAction{");
        sb.append("failed=").append(this.failed);
        sb.append(", pool=").append(this.pool);
        sb.append('}');
        return sb.toString();
    }
}

