/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pool;

import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.FailureDiagnostics;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class StatelessSessionPool
implements SessionPool {
    private static final Logger log = Logger.getLogger(StatelessSessionPool.class);
    private final FailureDiagnostics<BackgroundException> diagnostics = new DefaultFailureDiagnostics();
    private final ConnectionService connect;
    private final TranscriptListener transcript;
    private final Session<?> session;
    private final VaultRegistry registry;
    private final Lock lock = new ReentrantLock();

    public StatelessSessionPool(ConnectionService connect, Session<?> session, TranscriptListener transcript, VaultRegistry registry) {
        this.connect = connect;
        this.transcript = transcript;
        this.session = session.withRegistry(registry);
        this.registry = registry;
    }

    public Session<?> borrow(final BackgroundActionState callback) throws BackgroundException {
        this.lock.lock();
        try {
            this.connect.check(this.session.withListener(this.transcript), new CancelCallback(){

                @Override
                public void verify() throws ConnectionCanceledException {
                    if (callback.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                }
            });
            Session<?> session = this.session;
            return session;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void release(Session<?> conn, BackgroundException failure) {
        this.lock.lock();
        try {
            if (null == failure) {
                return;
            }
            if (this.diagnostics.determine(failure) == FailureDiagnostics.Type.network) {
                this.connect.close(conn);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evict() {
        this.lock.lock();
        try {
            try {
                this.session.close();
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Ignore failure closing connection. %s", e.getMessage()));
            }
            finally {
                this.session.removeListener(this.transcript);
                this.registry.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            try {
                this.session.close();
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Failure closing session. %s", e.getMessage()));
            }
            finally {
                this.registry.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Session.State getState() {
        return this.session.getState();
    }

    @Override
    public <T> T getFeature(Class<T> type) {
        return this.session.getFeature(type);
    }

    @Override
    public Host getHost() {
        return this.session.getHost();
    }

    @Override
    public VaultRegistry getVault() {
        return this.registry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StatelessSessionPool{");
        sb.append("session=").append(this.session);
        sb.append('}');
        return sb.toString();
    }
}

