/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.unicode.UnicodeNormalizer;
import org.apache.commons.lang3.StringUtils;

public class DefaultPathPredicate
implements CacheReference<Path> {
    private static final UnicodeNormalizer normalizer = new NFCNormalizer();
    private final String reference;

    public DefaultPathPredicate(Path file) {
        AbstractPath.Type type = file.isSymbolicLink() ? AbstractPath.Type.symboliclink : (file.isFile() ? AbstractPath.Type.file : AbstractPath.Type.directory);
        String qualifier = "";
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getRegion()) && new PathContainerService().isContainer(file)) {
            qualifier = qualifier + file.attributes().getRegion();
        }
        if (file.isFile() && StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            qualifier = qualifier + file.attributes().getVersionId();
        }
        this.reference = "[" + (Object)((Object)type) + "]-" + qualifier + normalizer.normalize(file.getAbsolute());
    }

    public String toString() {
        return this.reference;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof CacheReference && this.hashCode() == o.hashCode()) {
            return this.reference.equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.reference.hashCode();
    }

    @Override
    public boolean test(Path test) {
        return this.equals(new DefaultPathPredicate(test));
    }
}

