/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.local.WorkingDirectoryFinder;
import ch.cyberduck.core.local.WorkingDirectoryFinderFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkdirPrefixer {
    private final WorkingDirectoryFinder finder = WorkingDirectoryFinderFactory.get();

    private boolean isAbsolute(String path) {
        return FilenameUtils.getPrefixLength((String)path) != 0;
    }

    public String normalize(String name) {
        if (StringUtils.equals((CharSequence)name, (CharSequence)".")) {
            return this.finder.find().getAbsolute();
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"..")) {
            return this.finder.find().getParent().getAbsolute();
        }
        if (!this.isAbsolute(name)) {
            return String.format("%s%s%s", this.finder.find().getAbsolute(), PreferencesFactory.get().getProperty("local.delimiter"), name);
        }
        return name;
    }
}

