/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.features;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public interface Encryption {
    public Set<Algorithm> getKeys(Path var1, LoginCallback var2) throws BackgroundException;

    public void setEncryption(Path var1, Algorithm var2) throws BackgroundException;

    public Algorithm getDefault(Path var1) throws BackgroundException;

    public Algorithm getEncryption(Path var1) throws BackgroundException;

    public static class Algorithm {
        public static final Algorithm NONE = new Algorithm(null, null){

            @Override
            public String getDescription() {
                return LocaleFactory.localizedString("None");
            }

            @Override
            public String toString() {
                return "none";
            }
        };
        public final String algorithm;
        public final String key;

        public Algorithm(String algorithm, String key) {
            this.algorithm = algorithm;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Algorithm)) {
                return false;
            }
            Algorithm that = (Algorithm)o;
            return Objects.equals(this.algorithm, that.algorithm) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.algorithm, this.key);
        }

        public static Algorithm fromString(String value) {
            if (StringUtils.equals((CharSequence)NONE.toString(), (CharSequence)value)) {
                return NONE;
            }
            if (StringUtils.contains((CharSequence)value, (int)124)) {
                return new Algorithm(StringUtils.split((String)value, (char)'|')[0], StringUtils.split((String)value, (char)'|')[1]);
            }
            return new Algorithm(value, null);
        }

        public String toString() {
            if (null == this.key) {
                return this.algorithm;
            }
            return String.format("%s|%s", this.algorithm, this.key);
        }

        public String getDescription() {
            if (null == this.key) {
                return this.algorithm;
            }
            return this.key;
        }
    }
}

