/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.analytics;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.analytics.AnalyticsProvider;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class QloudstatAnalyticsProvider
implements AnalyticsProvider {
    private static final Logger log = Logger.getLogger(QloudstatAnalyticsProvider.class);
    private final String target;
    private final PathContainerService containerService = new PathContainerService();

    public QloudstatAnalyticsProvider() {
        this(PreferencesFactory.get().getProperty("analytics.provider.qloudstat.setup"));
    }

    public QloudstatAnalyticsProvider(String target) {
        this.target = target;
    }

    @Override
    public String getName() {
        return URI.create(this.target).getHost();
    }

    @Override
    public DescriptiveUrl getSetup(String hostname, Scheme method, Path container, Credentials credentials) {
        String setup = String.format("provider=%s,protocol=%s,endpoint=%s,key=%s,secret=%s", hostname, method.name(), this.containerService.getContainer(container).getName(), credentials.getUsername(), credentials.getPassword());
        String encoded = this.encode(new String(Base64.encodeBase64((byte[])setup.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        String formatted = String.format("%s?setup=%s", this.target, encoded);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Setup URL %s", formatted));
        }
        return new DescriptiveUrl(URI.create(formatted), DescriptiveUrl.Type.analytics);
    }

    private String encode(String p) {
        try {
            StringBuilder b = new StringBuilder();
            b.append(URLEncoder.encode(p, "UTF-8"));
            return StringUtils.replaceEach((String)b.toString(), (String[])new String[]{"+", "*", "%7E"}, (String[])new String[]{"%20", "%2A", "~"});
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

