/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.ProfileProtocolPredicate;
import ch.cyberduck.core.ProfileReaderFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.ApplicationResourcesFinderFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class ProtocolFactory {
    private static final Logger log = Logger.getLogger(ProtocolFactory.class);
    private static final ProtocolFactory global = new ProtocolFactory();
    private final Set<Protocol> registered;
    private final Local bundle;

    public static ProtocolFactory get() {
        return global;
    }

    public ProtocolFactory() {
        this(new LinkedHashSet<Protocol>());
    }

    public ProtocolFactory(Set<Protocol> protocols) {
        this(LocalFactory.get(ApplicationResourcesFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name")), protocols);
    }

    public ProtocolFactory(Local bundle, Set<Protocol> protocols) {
        this.bundle = bundle;
        this.registered = protocols;
    }

    public void register(Protocol ... protocols) {
        for (Protocol protocol : protocols) {
            this.register(protocol);
        }
    }

    public void loadDefaultProfiles() {
        Local library;
        if (this.bundle.exists()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Load profiles from %s", this.bundle));
                }
                for (Local local : this.bundle.list().filter(new ProfileFilter())) {
                    try {
                        Profile profile = ProfileReaderFactory.get().read(local);
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Adding bundled protocol %s", profile));
                        }
                        this.registered.add(profile);
                    }
                    catch (AccessDeniedException e) {
                        log.error((Object)String.format("Failure reading profile from %s. %s", local, e));
                    }
                }
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure reading collection %s %s", this.bundle, e));
            }
        }
        if ((library = LocalFactory.get(SupportDirectoryFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name"))).exists()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Load profiles from %s", library));
                }
                for (Local f : library.list().filter(new ProfileFilter())) {
                    try {
                        Profile profile = ProfileReaderFactory.get().read(f);
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Adding profile %s", profile));
                        }
                        this.registered.add(profile);
                    }
                    catch (AccessDeniedException e) {
                        log.warn((Object)String.format("Failure reading profile from %s. %s", f, e));
                    }
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                log.warn((Object)String.format("Failure reading collection %s %s", library, accessDeniedException));
            }
        }
    }

    public void register(Protocol protocol) {
        if (null == protocol) {
            log.error((Object)"Attempt to register unknown protocol");
            return;
        }
        this.registered.add(protocol);
    }

    public List<Protocol> find() {
        return this.find(Protocol::isEnabled);
    }

    public List<Protocol> find(Predicate<Protocol> search) {
        return this.registered.stream().filter(search).sorted().collect(Collectors.toList());
    }

    public Protocol forName(String identifier) {
        return this.forName(identifier, null);
    }

    public Protocol forName(String identifier, String provider) {
        return this.forName(this.find(), identifier, provider);
    }

    public Protocol forName(List<Protocol> enabled, String identifier, String provider) {
        Protocol match = enabled.stream().filter(protocol -> String.valueOf(protocol.hashCode()).equals(identifier)).findFirst().orElse(enabled.stream().filter(protocol -> new ProfileProtocolPredicate().test((Protocol)protocol) && StringUtils.equals((CharSequence)protocol.getProvider(), (CharSequence)provider)).findFirst().orElse(enabled.stream().filter(protocol -> StringUtils.equals((CharSequence)protocol.getProvider(), (CharSequence)identifier)).findFirst().orElse(enabled.stream().filter(protocol -> StringUtils.equals((CharSequence)String.format("%s-%s", protocol.getIdentifier(), protocol.getProvider()), (CharSequence)identifier)).findFirst().orElse(this.forScheme(enabled, identifier, enabled.stream().filter(protocol -> StringUtils.equals((CharSequence)protocol.getType().name(), (CharSequence)identifier)).findFirst().orElse(null))))));
        if (null == match) {
            if (enabled.isEmpty()) {
                log.error((Object)String.format("List of registered protocols in %s is empty", this));
            }
            log.error((Object)String.format("Missing registered protocol for identifier %s", identifier));
        }
        return match;
    }

    public Protocol forType(Protocol.Type type) {
        List<Protocol> enabled = this.find();
        return this.forType(enabled, type);
    }

    private Protocol forType(List<Protocol> enabled, Protocol.Type type) {
        return enabled.stream().filter(protocol -> protocol.getType().equals((Object)type)).findFirst().orElse(null);
    }

    public Protocol forScheme(Scheme scheme) {
        return this.forScheme(scheme.name(), null);
    }

    public Protocol forScheme(String scheme, Protocol fallback) {
        return this.forScheme(this.find(), scheme, fallback);
    }

    private Protocol forScheme(List<Protocol> enabled, String scheme, Protocol fallback) {
        String filter;
        switch (scheme) {
            case "http": {
                filter = Scheme.dav.name();
                break;
            }
            case "https": {
                filter = Scheme.davs.name();
                break;
            }
            default: {
                filter = scheme;
            }
        }
        return enabled.stream().filter(protocol -> Arrays.asList(protocol.getSchemes()).contains(filter)).findFirst().orElse(enabled.stream().filter(protocol -> Arrays.asList(protocol.getSchemes()).contains(scheme)).findFirst().orElse(fallback));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProtocolFactory{");
        sb.append("registered=").append(this.registered);
        sb.append(", bundle=").append(this.bundle);
        sb.append('}');
        return sb.toString();
    }

    private static final class ProfileFilter
    implements Filter<Local> {
        private ProfileFilter() {
        }

        @Override
        public boolean accept(Local file) {
            return "cyberduckprofile".equals(FilenameUtils.getExtension((String)file.getName()));
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile(".*\\.cyberduckprofile");
        }
    }
}

