/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.impl;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.cryptomator.ContentReader;
import ch.cyberduck.core.cryptomator.ContentWriter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;

public class CryptoFilenameProvider {
    private static final Logger log = Logger.getLogger(CryptoFilenameProvider.class);
    private static final BaseEncoding BASE32 = BaseEncoding.base32();
    private static final String LONG_NAME_FILE_EXT = ".lng";
    private static final String METADATA_DIR_NAME = "m";
    private static final int NAME_SHORTENING_THRESHOLD = 130;
    private final Path metadataRoot;
    private final LRUCache<String, String> cache = LRUCache.build((long)PreferencesFactory.get().getLong("browser.cache.size"));

    public CryptoFilenameProvider(Path vault) {
        this.metadataRoot = new Path(vault, METADATA_DIR_NAME, vault.getType());
    }

    public boolean isDeflated(String filename) {
        return filename.endsWith(LONG_NAME_FILE_EXT);
    }

    public String inflate(Session<?> session, String shortName) throws BackgroundException {
        return new ContentReader(session).read(this.resolve(shortName));
    }

    public String deflate(Session<?> session, String filename) throws BackgroundException {
        if (filename.length() < 130) {
            return filename;
        }
        if (this.cache.contains((Object)filename)) {
            return (String)this.cache.get((Object)filename);
        }
        byte[] longFileNameBytes = filename.getBytes(StandardCharsets.UTF_8);
        byte[] hash = MessageDigestSupplier.SHA1.get().digest(longFileNameBytes);
        String shortName = BASE32.encode(hash) + LONG_NAME_FILE_EXT;
        Path metadataFile = this.resolve(shortName);
        Path secondLevel = metadataFile.getParent();
        Path firstLevel = secondLevel.getParent();
        Directory mkdir = (Directory)session._getFeature(Directory.class);
        Find find = (Find)session._getFeature(Find.class);
        if (!find.find(this.metadataRoot)) {
            mkdir.mkdir(this.metadataRoot, null, new TransferStatus());
        }
        if (!find.find(firstLevel)) {
            mkdir.mkdir(firstLevel, null, new TransferStatus());
        }
        if (!find.find(secondLevel)) {
            mkdir.mkdir(secondLevel, null, new TransferStatus());
        }
        if (!find.find(metadataFile)) {
            new ContentWriter(session).write(metadataFile, longFileNameBytes);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Deflated %s to %s", filename, shortName));
        }
        this.cache.put((Object)filename, (Object)shortName);
        return shortName;
    }

    public Path resolve(String filename) {
        Path first = new Path(this.metadataRoot, filename.substring(0, 2), this.metadataRoot.getType());
        Path second = new Path(first, filename.substring(2, 4), this.metadataRoot.getType());
        return new Path(second, filename, EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.encrypted, AbstractPath.Type.vault));
    }

    public void invalidate(String filename) {
        this.cache.remove((Object)filename);
    }

    public void destroy() {
        this.cache.clear();
    }
}

