/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.threading.CancelCallback;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class BrickPairingInterceptor
extends DisabledServiceUnavailableRetryStrategy
implements CancelCallback {
    private static final Logger log = Logger.getLogger(BrickPairingInterceptor.class);
    private static final int MAX_RETRIES = 1;
    private final BrickSession session;
    private final ConnectionCallback prompt;
    private final AtomicBoolean pairing = new AtomicBoolean();
    private final AtomicBoolean cancel = new AtomicBoolean();

    public BrickPairingInterceptor(BrickSession session, ConnectionCallback prompt) {
        this.session = session;
        this.prompt = prompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (executionCount > 1) break;
                log.warn((Object)String.format("Attempt to obtain new pairing keys for response %s", response));
                try {
                    if (this.pairing.get()) {
                        this.cancel.set(true);
                    }
                    this.pairing.set(true);
                    Credentials credentials = this.session.pair(this.session.getHost(), this.prompt, this);
                    BasicCredentialsProvider provider = new BasicCredentialsProvider();
                    provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword()));
                    ((DAVClient)this.session.getClient()).setCredentials((CredentialsProvider)provider);
                }
                catch (BackgroundException e) {
                    log.warn((Object)String.format("Failure obtaining pairing key. %s", new Object[]{e}));
                }
                finally {
                    this.pairing.set(false);
                    this.cancel.set(false);
                }
                return true;
            }
        }
        return false;
    }

    public void verify() throws ConnectionCanceledException {
        if (this.cancel.get()) {
            throw new ConnectionCanceledException();
        }
    }
}

