/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import org.irods.jargon.core.connection.DiscoveredServerPropertiesCache;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.connection.auth.AuthResponse;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.pub.BulkFileOperationsAO;
import org.irods.jargon.core.pub.BulkFileOperationsAOImpl;
import org.irods.jargon.core.pub.CollectionAO;
import org.irods.jargon.core.pub.CollectionAOImpl;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAOImpl;
import org.irods.jargon.core.pub.CollectionAuditAO;
import org.irods.jargon.core.pub.CollectionAuditAOImpl;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.DataObjectAOImpl;
import org.irods.jargon.core.pub.DataObjectAuditAO;
import org.irods.jargon.core.pub.DataObjectAuditAOImpl;
import org.irods.jargon.core.pub.DataObjectChecksumUtilitiesAO;
import org.irods.jargon.core.pub.DataObjectChecksumUtilitiesAOImpl;
import org.irods.jargon.core.pub.DataTransferOperations;
import org.irods.jargon.core.pub.DataTransferOperationsImpl;
import org.irods.jargon.core.pub.EnvironmentalInfoAO;
import org.irods.jargon.core.pub.EnvironmentalInfoAOImpl;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.IRODSFileSystemAOImpl;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.IRODSRegistrationOfFilesAO;
import org.irods.jargon.core.pub.IRODSRegistrationOfFilesAOImpl;
import org.irods.jargon.core.pub.MountedCollectionAO;
import org.irods.jargon.core.pub.MountedCollectionAOImpl;
import org.irods.jargon.core.pub.ProtocolExtensionPoint;
import org.irods.jargon.core.pub.ProtocolExtensionPointImpl;
import org.irods.jargon.core.pub.QuotaAO;
import org.irods.jargon.core.pub.QuotaAOImpl;
import org.irods.jargon.core.pub.RemoteExecutionOfCommandsAO;
import org.irods.jargon.core.pub.RemoteExecutionOfCommandsAOImpl;
import org.irods.jargon.core.pub.ResourceAO;
import org.irods.jargon.core.pub.ResourceAOImpl;
import org.irods.jargon.core.pub.ResourceGroupAO;
import org.irods.jargon.core.pub.ResourceGroupAOImpl;
import org.irods.jargon.core.pub.RuleProcessingAO;
import org.irods.jargon.core.pub.RuleProcessingAOImpl;
import org.irods.jargon.core.pub.SimpleQueryExecutorAO;
import org.irods.jargon.core.pub.SimpleQueryExecutorAOImpl;
import org.irods.jargon.core.pub.SpecificQueryAO;
import org.irods.jargon.core.pub.SpecificQueryAOImpl;
import org.irods.jargon.core.pub.Stream2StreamAO;
import org.irods.jargon.core.pub.Stream2StreamAOImpl;
import org.irods.jargon.core.pub.UserAO;
import org.irods.jargon.core.pub.UserAOImpl;
import org.irods.jargon.core.pub.UserGroupAO;
import org.irods.jargon.core.pub.UserGroupAOImpl;
import org.irods.jargon.core.pub.ZoneAO;
import org.irods.jargon.core.pub.ZoneAOImpl;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileFactoryImpl;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSAccessObjectFactoryImpl
implements IRODSAccessObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(IRODSAccessObjectFactoryImpl.class);
    private IRODSSession irodsSession;

    @Override
    public AuthResponse authenticateIRODSAccount(IRODSAccount irodsAccount) throws AuthenticationException, JargonException {
        log.info("authenticateIRODSAccount()");
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        log.info("any existing session will be closed, or at least handed back to a pool/cache");
        this.irodsSession.closeSession(irodsAccount);
        AuthResponse authResponse = this.irodsSession.currentConnection(irodsAccount).getAuthResponse();
        log.info("authResponse:{}", (Object)authResponse);
        return authResponse;
    }

    @Override
    public AuthResponse authenticateIRODSAccountUtilizingCachedConnectionIfPresent(IRODSAccount irodsAccount) throws AuthenticationException, JargonException {
        log.info("authenticateIRODSAccountUtilizingCachedConnectionIfPresent()");
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        AuthResponse authResponse = this.irodsSession.currentConnection(irodsAccount).getAuthResponse();
        log.info("authResponse:{}", (Object)authResponse);
        return authResponse;
    }

    public IRODSAccessObjectFactoryImpl(IRODSSession irodsSession) {
        this.irodsSession = irodsSession;
    }

    public IRODSAccessObjectFactoryImpl() {
    }

    @Override
    public void closeSession() throws JargonException {
        if (this.irodsSession == null) {
            throw new JargonException("null session");
        }
        this.irodsSession.closeSession();
    }

    @Override
    public void closeSessionAndEatExceptions() {
        if (this.irodsSession == null) {
            return;
        }
        try {
            this.irodsSession.closeSession();
        }
        catch (Exception e) {
            log.warn("error encountered closing session, ignored", (Throwable)e);
        }
    }

    @Override
    public void closeSession(IRODSAccount irodsAccount) throws JargonException {
        if (this.irodsSession == null) {
            throw new JargonException("null session");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        this.irodsSession.closeSession(irodsAccount);
    }

    @Override
    public void closeSessionAndEatExceptions(IRODSAccount irodsAccount) {
        if (this.irodsSession == null) {
            return;
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        try {
            this.irodsSession.closeSession(irodsAccount);
        }
        catch (Exception e) {
            log.warn("error encountered closing session, ignored", (Throwable)e);
        }
    }

    public static IRODSAccessObjectFactory instance(IRODSSession irodsSession) throws JargonException {
        if (irodsSession == null) {
            log.error("null irods session");
            throw new IllegalArgumentException("IRODSSession cannot be null");
        }
        log.debug("creating access object factory");
        return new IRODSAccessObjectFactoryImpl(irodsSession);
    }

    @Override
    public UserAO getUserAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new UserAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public UserGroupAO getUserGroupAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new UserGroupAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public EnvironmentalInfoAO getEnvironmentalInfoAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new EnvironmentalInfoAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public QuotaAO getQuotaAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new QuotaAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public IRODSGenQueryExecutor getIRODSGenQueryExecutor(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new IRODSGenQueryExecutorImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public ZoneAO getZoneAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new ZoneAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public ResourceAO getResourceAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new ResourceAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public ResourceGroupAO getResourceGroupAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new ResourceGroupAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public IRODSFileSystemAO getIRODSFileSystemAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new IRODSFileSystemAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public IRODSFileFactory getIRODSFileFactory(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new IRODSFileFactoryImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public CollectionAO getCollectionAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new CollectionAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public DataObjectAO getDataObjectAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new DataObjectAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public DataObjectAuditAO getDataObjectAuditAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new DataObjectAuditAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public CollectionAuditAO getCollectionAuditAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new CollectionAuditAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public RuleProcessingAO getRuleProcessingAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new RuleProcessingAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public DataTransferOperations getDataTransferOperations(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new DataTransferOperationsImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public BulkFileOperationsAO getBulkFileOperationsAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new BulkFileOperationsAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public RemoteExecutionOfCommandsAO getRemoteExecutionOfCommandsAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new RemoteExecutionOfCommandsAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public CollectionAndDataObjectListAndSearchAO getCollectionAndDataObjectListAndSearchAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new CollectionAndDataObjectListAndSearchAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public SimpleQueryExecutorAO getSimpleQueryExecutorAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new SimpleQueryExecutorAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public Stream2StreamAO getStream2StreamAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new Stream2StreamAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public MountedCollectionAO getMountedCollectionAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new MountedCollectionAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public ProtocolExtensionPoint getProtocolExtensionPoint(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new ProtocolExtensionPointImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public IRODSRegistrationOfFilesAO getIRODSRegistrationOfFilesAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new IRODSRegistrationOfFilesAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public IRODSSession getIrodsSession() {
        return this.irodsSession;
    }

    @Override
    public void setIrodsSession(IRODSSession irodsSession) {
        this.irodsSession = irodsSession;
    }

    private void checkIrodsSessionSet() throws JargonException {
        if (this.irodsSession == null) {
            throw new JargonException("no irodsSession was set, this is likely due to wiring the IRODSAccessObjectFactory without setting the irodsSession property");
        }
    }

    @Override
    public JargonProperties getJargonProperties() throws JargonException {
        this.checkIrodsSessionSet();
        return this.irodsSession.getJargonProperties();
    }

    @Override
    public final IRODSServerProperties getIRODSServerProperties(IRODSAccount irodsAccount) throws JargonException {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (this.isUsingDynamicServerPropertiesCache() && this.getIrodsSession().getDiscoveredServerPropertiesCache().retrieveValue(irodsAccount.getHost(), irodsAccount.getZone(), "eirods") == null) {
            log.info("need to cache and update isEirods");
            this.getEnvironmentalInfoAO(irodsAccount);
        }
        return this.irodsSession.currentConnection(irodsAccount).getIRODSServerProperties();
    }

    @Override
    public TransferControlBlock buildDefaultTransferControlBlockBasedOnJargonProperties() throws JargonException {
        this.checkIrodsSessionSet();
        return this.irodsSession.buildDefaultTransferControlBlockBasedOnJargonProperties();
    }

    @Override
    public TransferOptions buildTransferOptionsBasedOnJargonProperties() throws JargonException {
        this.checkIrodsSessionSet();
        return this.irodsSession.buildTransferOptionsBasedOnJargonProperties();
    }

    @Override
    public SpecificQueryAO getSpecificQueryAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new SpecificQueryAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public DataObjectChecksumUtilitiesAO getDataObjectChecksumUtilitiesAO(IRODSAccount irodsAccount) throws JargonException {
        this.checkIrodsSessionSet();
        return new DataObjectChecksumUtilitiesAOImpl(this.irodsSession, irodsAccount);
    }

    @Override
    public DiscoveredServerPropertiesCache getDiscoveredServerPropertiesCache() {
        return this.getIrodsSession().getDiscoveredServerPropertiesCache();
    }

    @Override
    public boolean isUsingDynamicServerPropertiesCache() {
        return this.getIrodsSession().isUsingDynamicServerPropertiesCache();
    }
}

