/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.spectrads3.CancelJobSpectraS3Request;
import com.spectralogic.ds3client.exceptions.Ds3NoMoreRetriesException;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.JobState;
import com.spectralogic.ds3client.helpers.events.FailureEvent;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.BlobStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategy;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.models.Objects;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTransferStrategy
implements TransferStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransferStrategy.class);
    private final BlobStrategy blobStrategy;
    private final JobState jobState;
    private final ExecutorService executorService;
    private final EventDispatcher eventDispatcher;
    private final MasterObjectList masterObjectList;
    private final Ds3Client ds3Client;
    private final FailureEvent.FailureActivity failureActivity;
    private final AtomicReference<IOException> cachedException = new AtomicReference();
    private volatile boolean canceled = false;
    private TransferMethod transferMethod;

    public AbstractTransferStrategy(BlobStrategy blobStrategy, JobState jobState, ExecutorService executorService, EventDispatcher eventDispatcher, MasterObjectList masterObjectList, Ds3Client ds3Client, FailureEvent.FailureActivity failureActivity) {
        this.blobStrategy = blobStrategy;
        this.jobState = jobState;
        this.executorService = executorService;
        this.eventDispatcher = eventDispatcher;
        this.masterObjectList = masterObjectList;
        this.ds3Client = ds3Client;
        this.failureActivity = failureActivity;
    }

    public AbstractTransferStrategy withTransferMethod(TransferMethod transferMethod) {
        this.transferMethod = transferMethod;
        return this;
    }

    @Override
    public void transfer() throws IOException {
        this.cachedException.set(null);
        try {
            this.transferAllJobBlobs();
        }
        finally {
            this.close();
        }
        if (this.cachedException.get() != null) {
            throw this.cachedException.get();
        }
    }

    private void transferAllJobBlobs() throws IOException {
        BooleanSupplier cancellationCheck = () -> !this.canceled;
        AtomicInteger numBlobsRemaining = new AtomicInteger(this.jobState.numBlobsInJob());
        while (!Thread.currentThread().isInterrupted() && cancellationCheck.getAsBoolean() && numBlobsRemaining.get() > 0) {
            try {
                Iterable<JobPart> jobParts = this.jobPartsNotAlreadyTransferred(cancellationCheck);
                int numJobParts = Iterables.size(jobParts);
                if (numJobParts <= 0) break;
                CountDownLatch jobPartsCompleteLatch = new CountDownLatch(numJobParts);
                this.transferJobParts(jobParts, jobPartsCompleteLatch, numBlobsRemaining, cancellationCheck);
                jobPartsCompleteLatch.await();
            }
            catch (Ds3NoMoreRetriesException | FailedRequestException e) {
                this.emitFailureEvent(this.makeFailureEvent(this.failureActivity, e, this.firstChunk()));
                throw e;
            }
            catch (InterruptedException | NoSuchElementException e) {
                LOG.warn("Thread was interrupted");
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                this.emitFailureAndSetCachedException(t);
            }
        }
    }

    private Iterable<JobPart> jobPartsNotAlreadyTransferred(BooleanSupplier cancellationCheck) throws IOException, InterruptedException {
        if (!cancellationCheck.getAsBoolean()) {
            return FluentIterable.of();
        }
        return FluentIterable.from(this.blobStrategy.getWork()).filter(jobPart -> this.jobState.contains(jobPart.getBlob()) && cancellationCheck.getAsBoolean());
    }

    private void emitFailureAndSetCachedException(Throwable t) {
        this.emitFailureEvent(this.makeFailureEvent(this.failureActivity, t, this.firstChunk()));
        this.maybeSetCachedException(t);
    }

    private synchronized void maybeSetCachedException(Throwable t) {
        if (this.cachedException.get() == null) {
            if (t instanceof IOException) {
                this.cachedException.set((IOException)t);
            } else {
                this.cachedException.set(new IOException(t));
            }
        }
    }

    private void transferJobParts(Iterable<JobPart> jobParts, CountDownLatch jobPartsCompleteLatch, AtomicInteger numBlobsTransferred, BooleanSupplier cancellationCheck) {
        for (JobPart jobPart : jobParts) {
            if (this.executorService.isShutdown()) {
                LOG.debug("Executor service is shut down, decrementing countdown latch");
                jobPartsCompleteLatch.countDown();
                continue;
            }
            this.executorService.execute(() -> {
                try {
                    if (cancellationCheck.getAsBoolean()) {
                        this.transferMethod.transferJobPart(jobPart);
                    }
                }
                catch (RuntimeException e) {
                    this.emitFailureAndSetCachedException(e);
                    throw e;
                }
                catch (Exception e) {
                    this.emitFailureAndSetCachedException(e);
                    throw new RuntimeException(e);
                }
                finally {
                    this.jobState.blobTransferredOrFailed(jobPart.getBlob());
                    numBlobsTransferred.decrementAndGet();
                    jobPartsCompleteLatch.countDown();
                }
            });
        }
    }

    private void emitFailureEvent(FailureEvent failureEvent) {
        this.eventDispatcher.emitFailureEvent(failureEvent);
    }

    private FailureEvent makeFailureEvent(FailureEvent.FailureActivity failureActivity, Throwable causalException, Objects chunk) {
        return new FailureEvent.Builder().doingWhat(failureActivity).withCausalException(causalException).withObjectNamed(this.labelForChunk(chunk)).usingSystemWithEndpoint(this.masterObjectList.getNodes().get(0).getEndPoint()).build();
    }

    private String labelForChunk(Objects chunk) {
        try {
            return chunk.getObjects().get(0).getName();
        }
        catch (Throwable t) {
            LOG.error("Failed to get label for chunk.", t);
            return "unnamed object";
        }
    }

    private Objects firstChunk() {
        return this.masterObjectList.getObjects().get(0);
    }

    @Override
    public void close() {
        this.canceled = true;
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
        }
    }

    @Override
    public void cancel() throws IOException {
        this.close();
        UUID jobId = this.masterObjectList.getJobId();
        this.ds3Client.cancelJobSpectraS3(new CancelJobSpectraS3Request(jobId));
        this.eventDispatcher.emitCanceledEvent(jobId);
    }
}

