/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.DataIsolationLevel;
import com.spectralogic.ds3client.models.DataPersistenceRuleType;
import com.spectralogic.ds3client.models.DataPlacementRuleState;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetDataPersistenceRulesSpectraS3Request
extends AbstractPaginationRequest {
    private String dataPolicyId;
    private DataIsolationLevel isolationLevel;
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private DataPlacementRuleState state;
    private String storageDomainId;
    private DataPersistenceRuleType type;

    public GetDataPersistenceRulesSpectraS3Request withDataPolicyId(UUID dataPolicyId) {
        this.dataPolicyId = dataPolicyId.toString();
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withDataPolicyId(String dataPolicyId) {
        this.dataPolicyId = dataPolicyId;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withIsolationLevel(DataIsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        this.updateQueryParam("isolation_level", isolationLevel);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withState(DataPlacementRuleState state) {
        this.state = state;
        this.updateQueryParam("state", state);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withStorageDomainId(UUID storageDomainId) {
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withStorageDomainId(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public GetDataPersistenceRulesSpectraS3Request withType(DataPersistenceRuleType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/data_persistence_rule";
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public DataIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public DataPlacementRuleState getState() {
        return this.state;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public DataPersistenceRuleType getType() {
        return this.type;
    }
}

