/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.StorageObject;

public class S3MetadataFeature
implements Headers {
    private static final Logger log = Logger.getLogger(S3MetadataFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3AccessControlListFeature accessControlListFeature;

    public S3MetadataFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
    }

    public Map<String, String> getDefault(Local local) {
        return PreferencesFactory.get().getMap("s3.metadata.default");
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            try {
                return new S3AttributesFinderFeature(this.session).find(file).getMetadata();
            }
            catch (NotfoundException e) {
                if (file.isPlaceholder()) {
                    return Collections.emptyMap();
                }
                throw e;
            }
        }
        return Collections.emptyMap();
    }

    public void setMetadata(Path file, Map<String, String> metadata) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Write metadata %s for file %s", metadata, file));
            }
            try {
                Encryption encryptionFeature;
                Redundancy storageClassFeature;
                StorageObject target = new S3AttributesFinderFeature(this.session).details(file);
                target.replaceAllMetadata(new HashMap<String, String>(metadata));
                if (this.accessControlListFeature != null) {
                    Acl acl = Acl.EMPTY;
                    try {
                        acl = this.accessControlListFeature.getPermission(file);
                    }
                    catch (AccessDeniedException | InteroperabilityException e) {
                        log.warn((Object)String.format("Ignore failure %s", e));
                    }
                    target.setAcl(this.accessControlListFeature.convert(acl));
                }
                if ((storageClassFeature = (Redundancy)this.session.getFeature(Redundancy.class)) != null) {
                    target.setStorageClass(storageClassFeature.getClass(file));
                }
                if ((encryptionFeature = (Encryption)this.session.getFeature(Encryption.class)) != null) {
                    Encryption.Algorithm encryption = encryptionFeature.getEncryption(file);
                    target.setServerSideEncryptionAlgorithm(encryption.algorithm);
                    target.setServerSideEncryptionKmsKeyId(encryption.key);
                }
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).updateObjectMetadata(this.containerService.getContainer(file).getName(), target);
            }
            catch (ServiceException e) {
                BackgroundException failure = new S3ExceptionMappingService().map("Failure to write attributes of {0}", e, file);
                if (file.isPlaceholder() && failure instanceof NotfoundException) {
                    return;
                }
                throw failure;
            }
        }
    }
}

