/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public class LocalTimestampFeature
extends DefaultTimestampFeature {
    private final LocalSession session;

    public LocalTimestampFeature(LocalSession session) {
        this.session = session;
    }

    public void setTimestamp(Path file, Long modified) throws BackgroundException {
        try {
            Files.setLastModifiedTime(this.session.toPath(file), FileTime.from(modified, TimeUnit.MILLISECONDS));
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

