/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

class JsonObjectIterator
implements Iterator<JsonObject> {
    private final OneDriveAPI api;
    private URL url;
    private boolean hasMorePages;
    private Iterator<JsonValue> currentPage;

    public JsonObjectIterator(OneDriveAPI api, URL url) {
        this.api = api;
        this.url = url;
        this.hasMorePages = true;
    }

    @Override
    public boolean hasNext() throws OneDriveRuntimeException {
        if (this.currentPage != null && this.currentPage.hasNext()) {
            return true;
        }
        if (this.hasMorePages) {
            this.loadNextPage();
            return this.currentPage != null && this.currentPage.hasNext();
        }
        return false;
    }

    @Override
    public JsonObject next() throws OneDriveRuntimeException {
        if (this.hasNext()) {
            return this.currentPage.next().asObject();
        }
        throw new NoSuchElementException();
    }

    private void loadNextPage() throws OneDriveRuntimeException {
        try {
            OneDriveJsonRequest request = new OneDriveJsonRequest(this.url, "GET");
            OneDriveJsonResponse response = request.sendRequest(this.api.getExecutor());
            JsonObject json = response.getContent();
            this.onResponse(json);
            JsonValue values = json.get("value");
            this.currentPage = values.isNull() ? Collections.emptyIterator() : values.asArray().iterator();
            JsonValue nextUrl = json.get("@odata.nextLink");
            boolean bl = this.hasMorePages = nextUrl != null && !nextUrl.isNull();
            if (this.hasMorePages) {
                this.url = new URL(nextUrl.asString());
            }
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveRuntimeException(e);
        }
        catch (IOException e) {
            throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
        }
    }

    protected void onResponse(JsonObject response) {
    }
}

