/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.VoidStatusOutputStream;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class AzureWriteFeature
extends AppendWriteFeature<Void>
implements Write<Void> {
    private static final Logger log = Logger.getLogger(AzureWriteFeature.class);
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();
    private final Preferences preferences = PreferencesFactory.get();

    public AzureWriteFeature(AzureSession session, OperationContext context) {
        super((Session)session);
        this.session = session;
        this.context = context;
    }

    public AzureWriteFeature(AzureSession session, OperationContext context, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.context = context;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum(Path file) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5);
    }

    public StatusOutputStream<Void> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            BlobOutputStream out;
            Checksum checksum;
            if (status.isExists() && this.preferences.getBoolean("azure.upload.snapshot")) {
                ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file)).createSnapshot();
            }
            CloudAppendBlob blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getAppendBlobReference(this.containerService.getKey(file));
            if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                blob.getProperties().setContentType(status.getMime());
            }
            HashMap headers = new HashMap(status.getMetadata());
            blob.setMetadata(headers);
            if (headers.containsKey("Cache-Control")) {
                blob.getProperties().setCacheControl((String)headers.get("Cache-Control"));
                headers.remove("Cache-Control");
            }
            if (headers.containsKey("Content-Type")) {
                blob.getProperties().setContentType((String)headers.get("Content-Type"));
                headers.remove("Content-Type");
            }
            if (Checksum.NONE != (checksum = status.getChecksum())) {
                switch (checksum.algorithm) {
                    case md5: {
                        try {
                            blob.getProperties().setContentMD5(Base64.toBase64String((byte[])Hex.decodeHex((char[])status.getChecksum().hash.toCharArray())));
                            headers.remove("Content-MD5");
                            break;
                        }
                        catch (DecoderException decoderException) {
                            // empty catch block
                        }
                    }
                }
            }
            BlobRequestOptions options = new BlobRequestOptions();
            options.setConcurrentRequestCount(Integer.valueOf(1));
            options.setStoreBlobContentMD5(Boolean.valueOf(this.preferences.getBoolean("azure.upload.md5")));
            if (status.isAppend()) {
                options.setStoreBlobContentMD5(Boolean.valueOf(false));
                out = blob.openWriteExisting(AccessCondition.generateEmptyCondition(), options, this.context);
            } else {
                out = blob.openWriteNew(AccessCondition.generateEmptyCondition(), options, this.context);
            }
            return new VoidStatusOutputStream((OutputStream)out){

                protected void handleIOException(IOException e) throws IOException {
                    if (StringUtils.equals((CharSequence)"Stream is already closed.", (CharSequence)e.getMessage())) {
                        log.warn((Object)String.format("Ignore failure %s", e));
                        return;
                    }
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
                    if (cause instanceof StorageException) {
                        throw new IOException(e.getMessage(), (Throwable)new AzureExceptionMappingService().map((StorageException)cause));
                    }
                    throw e;
                }
            };
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
    }
}

