/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaCaret;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaHighlighter;
import com.apple.laf.AquaKeyBindings;
import com.apple.laf.AquaUtilControlSize;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaTextAreaUI
extends BasicTextAreaUI {
    AquaFocusHandler handler;
    boolean oldDragState = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTextAreaUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent jTextComponent = this.getComponent();
        this.handler = new AquaFocusHandler();
        jTextComponent.addFocusListener(this.handler);
        jTextComponent.addPropertyChangeListener(this.handler);
        AquaUtilControlSize.addSizePropertyListener(jTextComponent);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent jTextComponent = this.getComponent();
        AquaUtilControlSize.removeSizePropertyListener(jTextComponent);
        jTextComponent.removeFocusListener(this.handler);
        jTextComponent.removePropertyChangeListener(this.handler);
        this.handler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.getComponent().getDragEnabled();
            this.getComponent().setDragEnabled(true);
        }
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        aquaKeyBindings.setDefaultAction(this.getKeymapName());
        JTextComponent jTextComponent = this.getComponent();
        aquaKeyBindings.installAquaUpDownActions(jTextComponent);
    }

    @Override
    protected Caret createCaret() {
        JTextComponent jTextComponent = this.getComponent();
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        AquaCaret aquaCaret = new AquaCaret(window, jTextComponent);
        return aquaCaret;
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }
}

