/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.preferences.PreferencesFactory;

public class NSObjectPathReference
implements CacheReference<Path> {
    private static final LRUCache<Path, NSString> cache = LRUCache.build((long)PreferencesFactory.get().getInteger("browser.model.cache.size"));
    private final int hashCode;

    public static NSObject get(Path file) {
        if (!cache.contains((Object)file)) {
            cache.put((Object)file, (Object)NSString.stringWithString((String)new DefaultPathPredicate(file).toString()));
        }
        return (NSObject)cache.get((Object)file);
    }

    public NSObjectPathReference(NSObject reference) {
        this.hashCode = reference.toString().hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof CacheReference) {
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NSObjectPathReference{");
        sb.append("hashCode=").append(this.hashCode);
        sb.append('}');
        return sb.toString();
    }

    public boolean test(Path file) {
        return this.hashCode == file.hashCode();
    }
}

