/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.io.IOException;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveItem;

public class GraphQuotaFeature
implements Quota {
    private final GraphSession session;

    public GraphQuotaFeature(GraphSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        OneDriveDrive.Metadata metadata;
        Path home = new DefaultHomeFinderService((Session)this.session).find();
        if (!this.session.isAccessible(home)) {
            return new Quota.Space(Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE));
        }
        try {
            OneDriveItem item = this.session.toItem(home, true);
            metadata = item.getDrive().getMetadata(new OneDriveExpand[0]);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Failure to read attributes of {0}", e, home);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, home);
        }
        return new Quota.Space(Long.valueOf(metadata.getUsed() != null ? metadata.getUsed() : 0L), Long.valueOf(metadata.getTotal() != null ? metadata.getTotal() : Long.MAX_VALUE));
    }
}

