/*
 * Decompiled with CFR 0.152.
 */
package io.milton.context;

import io.milton.context.Context;
import io.milton.context.RemovalCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Registration<T> {
    public final T item;
    public final RemovalCallback callBack;
    public List<Registration> dependents;
    private List<String> keyIds;
    private List<Class> keyClasses;
    private boolean removing;
    private WeakReference<Context> refParent;

    public Registration(T o, RemovalCallback callBack, Context parent) {
        this.item = o;
        this.callBack = callBack;
        this.refParent = new WeakReference<Context>(parent);
    }

    private Context context() {
        return (Context)this.refParent.get();
    }

    public void addDependent(Registration rm) {
        if (this.dependents == null) {
            this.dependents = new Stack<Registration>();
        }
        this.dependents.add(0, rm);
    }

    public void addKey(String id) {
        if (this.keyIds == null) {
            this.keyIds = new ArrayList<String>();
        }
        this.keyIds.add(id);
    }

    public void addKey(Class c) {
        if (this.keyClasses == null) {
            this.keyClasses = new ArrayList<Class>();
        }
        this.keyClasses.add(c);
    }

    public boolean contains(Class c) {
        if (this.keyClasses == null) {
            return false;
        }
        return this.keyClasses.contains(c);
    }

    public void remove() {
        if (this.removing) {
            return;
        }
        this.removing = true;
        if (this.dependents != null) {
            for (Registration rm : this.dependents) {
                rm.remove();
            }
            this.dependents = null;
        }
        if (this.callBack != null) {
            this.callBack.onRemove(this.item);
        }
        if (this.keyIds != null) {
            for (String id : this.keyIds) {
                this.context().itemByName.remove(id);
            }
            this.keyIds = null;
        }
        if (this.keyClasses != null) {
            for (Class c : this.keyClasses) {
                this.context().itemByClass.remove(c);
            }
            this.keyClasses = null;
        }
    }
}

