/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.ContentTypeService;
import io.milton.common.DefaultContentTypeService;
import io.milton.common.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeUtils {
    private static Logger log = LoggerFactory.getLogger(ContentTypeUtils.class);
    private static final ContentTypeService contentTypeService = new DefaultContentTypeService();

    public static String findContentTypes(String name) {
        List<String> list = contentTypeService.findContentTypes(name);
        return ContentTypeUtils.buildContentTypeText(list);
    }

    public static String findContentTypes(File file) {
        return ContentTypeUtils.buildContentTypeText(contentTypeService.findContentTypes(file.getName()));
    }

    public static String findAcceptableContentType(String canProvide, String accepts) {
        return contentTypeService.getPreferedMimeType(accepts, ContentTypeUtils.toList(canProvide));
    }

    public static String findAcceptableContentTypeForName(String name, String accepts) {
        String canProvide = ContentTypeUtils.findContentTypes(name);
        List<String> canProvideList = ContentTypeUtils.toList(canProvide);
        String s = contentTypeService.getPreferedMimeType(accepts, canProvideList);
        return s;
    }

    private static String buildContentTypeText(List<String> mimeTypes) {
        return Utils.toCsv(mimeTypes);
    }

    public static List<String> toList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        if (s != null) {
            for (String x : s.split(",")) {
                x = x.trim();
                list.add(x);
            }
        }
        return list;
    }
}

