/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model.cloudfront;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.Origin;
import org.jets3t.service.model.cloudfront.StreamingDistribution;

public class Distribution {
    private String id = null;
    private String status = null;
    private Date lastModifiedTime = null;
    private Long inProgressInvalidationBatches = 0L;
    private String domainName = null;
    private Map activeTrustedSigners = new HashMap();
    private DistributionConfig config = new DistributionConfig();

    public Distribution(String id, String status, Date lastModifiedDate, Long inProgressInvalidationBatches, String domainName, Map activeTrustedSigners, DistributionConfig config) {
        this.id = id;
        this.status = status;
        this.lastModifiedTime = lastModifiedDate;
        this.inProgressInvalidationBatches = inProgressInvalidationBatches;
        this.domainName = domainName;
        this.config = config;
    }

    @Deprecated
    public Distribution(String id, String status, Date lastModifiedDate, String domainName, Origin origin, String[] cnames, String comment, boolean enabled) {
        this.id = id;
        this.status = status;
        this.lastModifiedTime = lastModifiedDate;
        this.domainName = domainName;
        this.config.setOrigins(new Origin[]{origin});
        this.config.setCNAMEs(cnames);
        this.config.setComment(comment);
        this.config.setEnabled(enabled);
    }

    @Deprecated
    public Distribution(String id, String status, Date lastModifiedDate, String domainName, Map activeTrustedSigners, DistributionConfig config) {
        this.id = id;
        this.status = status;
        this.lastModifiedTime = lastModifiedDate;
        this.domainName = domainName;
        this.activeTrustedSigners = activeTrustedSigners;
        this.config = config;
    }

    public boolean isSummary() {
        return this.getConfig() == null;
    }

    @Deprecated
    public String getComment() {
        return this.config.getComment();
    }

    public Long getInProgressInvalidationBatches() {
        return this.inProgressInvalidationBatches;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Map getActiveTrustedSigners() {
        return this.activeTrustedSigners;
    }

    public String getId() {
        return this.id;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Deprecated
    public Origin getOrigin() {
        return this.config.getOrigin();
    }

    @Deprecated
    public String[] getCNAMEs() {
        return this.config.getCNAMEs();
    }

    @Deprecated
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isDeployed() {
        return "Deployed".equals(this.getStatus());
    }

    public DistributionConfig getConfig() {
        return this.config;
    }

    public boolean isStreamingDistribution() {
        return this instanceof StreamingDistribution;
    }

    public String toString() {
        return (this.isStreamingDistribution() ? "CloudFrontStreamingDistribution" : "CloudFrontDistribution") + ": id=" + this.id + ", status=" + this.status + ", domainName=" + this.domainName + ", activeTrustedSigners=" + this.activeTrustedSigners + ", lastModifiedTime=" + this.lastModifiedTime + ", config=" + this.getConfig().toString();
    }
}

