/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.blobstrategy;

import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.BlobStrategy;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryDelayBehavior;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.BlobTransferredEventObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.UpdateStrategy;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.MasterObjectList;

public abstract class AbstractBlobStrategy
implements BlobStrategy {
    private final Ds3Client client;
    private final MasterObjectList masterObjectList;
    private final EventDispatcher eventDispatcher;
    private final ChunkAttemptRetryBehavior retryBehavior;
    private final ChunkAttemptRetryDelayBehavior chunkAttemptRetryDelayBehavior;

    public AbstractBlobStrategy(Ds3Client client, MasterObjectList masterObjectList, EventDispatcher eventDispatcher, ChunkAttemptRetryBehavior retryBehavior, ChunkAttemptRetryDelayBehavior chunkAttemptRetryDelayBehavior) {
        this.client = client;
        this.masterObjectList = masterObjectList;
        this.eventDispatcher = eventDispatcher;
        this.retryBehavior = retryBehavior;
        this.chunkAttemptRetryDelayBehavior = chunkAttemptRetryDelayBehavior;
        eventDispatcher.attachBlobTransferredEventObserver(new BlobTransferredEventObserver(new UpdateStrategy<BulkObject>(){

            @Override
            public void update(BulkObject eventData) {
                AbstractBlobStrategy.this.blobCompleted(eventData);
            }
        }));
    }

    public abstract void blobCompleted(BulkObject var1);

    public Ds3Client client() {
        return this.client;
    }

    public EventDispatcher eventDispatcher() {
        return this.eventDispatcher;
    }

    public MasterObjectList masterObjectList() {
        return this.masterObjectList;
    }

    public ChunkAttemptRetryBehavior retryBehavior() {
        return this.retryBehavior;
    }

    public ChunkAttemptRetryDelayBehavior chunkAttemptRetryDelayBehavior() {
        return this.chunkAttemptRetryDelayBehavior;
    }
}

