/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.delete.Delete;
import com.spectralogic.ds3client.models.delete.DeleteObject;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectsRequest
extends AbstractRequest {
    private final List<String> objects;
    private final String bucketName;
    private boolean quiet = false;
    private long size;

    public DeleteObjectsRequest(String bucketName, List<String> objects) {
        this.bucketName = bucketName;
        this.objects = objects;
        this.getQueryParams().put("delete", null);
    }

    public DeleteObjectsRequest(String bucketName, Iterable<Contents> objs) {
        this.bucketName = bucketName;
        this.getQueryParams().put("delete", null);
        this.objects = DeleteObjectsRequest.contentsToString(objs);
    }

    private static List<String> contentsToString(Iterable<Contents> objs) {
        ArrayList<String> objKeyList = new ArrayList<String>();
        for (Contents obj : objs) {
            objKeyList.add(obj.getKey());
        }
        return objKeyList;
    }

    public DeleteObjectsRequest withQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public InputStream getStream() {
        Delete delete = new Delete();
        delete.setQuiet(this.quiet);
        ArrayList<DeleteObject> deleteObjects = new ArrayList<DeleteObject>();
        for (String objName : this.objects) {
            deleteObjects.add(new DeleteObject(objName));
        }
        delete.setDeleteObjectList(deleteObjects);
        String xmlOutput = XmlOutput.toXml(delete);
        byte[] stringBytes = xmlOutput.getBytes(Charset.forName("UTF-8"));
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName;
    }

    public List<String> getObjects() {
        return this.objects;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

