/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Vault;
import org.apache.log4j.Logger;

public class DecryptingListProgressListener
extends IndexedListProgressListener {
    private static final Logger log = Logger.getLogger(DecryptingListProgressListener.class);
    private final Session<?> session;
    private final Vault vault;
    private final ListProgressListener delegate;

    public DecryptingListProgressListener(Session<?> session, Vault vault, ListProgressListener delegate) {
        this.session = session;
        this.vault = vault;
        this.delegate = delegate;
    }

    @Override
    public void visit(AttributedList<Path> list, int index, Path f) {
        try {
            f.getType().add(AbstractPath.Type.encrypted);
            list.set(index, this.vault.decrypt(this.session, f));
        }
        catch (BackgroundException e) {
            log.error((Object)String.format("Failure decrypting %s. %s", f, e.getDetail()));
            f.getType().remove((Object)AbstractPath.Type.encrypted);
        }
    }

    @Override
    public void chunk(Path folder, AttributedList<Path> list) throws ConnectionCanceledException {
        super.chunk(folder, list);
        this.delegate.chunk(folder, list);
    }

    @Override
    public void message(String message) {
        this.delegate.message(message);
    }
}

