/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.local.ApplicationLauncher;
import ch.cyberduck.core.local.ApplicationLauncherFactory;
import ch.cyberduck.core.local.IconService;
import ch.cyberduck.core.local.IconServiceFactory;
import ch.cyberduck.core.local.QuarantineService;
import ch.cyberduck.core.local.QuarantineServiceFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDownloadFilter
implements TransferPathFilter {
    private static final Logger log = Logger.getLogger(AbstractDownloadFilter.class);
    private final SymlinkResolver<Path> symlinkResolver;
    private final QuarantineService quarantine = QuarantineServiceFactory.get();
    private final ApplicationLauncher launcher = ApplicationLauncherFactory.get();
    private final Preferences preferences = PreferencesFactory.get();
    private final IconService icon = IconServiceFactory.get();
    private final Session<?> session;
    protected AttributesFinder attribute;
    private DownloadFilterOptions options;

    protected AbstractDownloadFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options) {
        this.symlinkResolver = symlinkResolver;
        this.session = session;
        this.options = options;
        this.attribute = session.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(session));
    }

    @Override
    public AbstractDownloadFilter withCache(Cache<Path> cache) {
        this.attribute.withCache(cache);
        return this;
    }

    public AbstractDownloadFilter withAttributes(AttributesFinder attribute) {
        this.attribute = attribute;
        return this;
    }

    public AbstractDownloadFilter withOptions(DownloadFilterOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        Local volume = local.getVolume();
        if (!volume.exists()) {
            throw new NotfoundException(String.format("Volume %s not mounted", volume.getAbsolute()));
        }
        return true;
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        Download read;
        PathAttributes attributes;
        TransferStatus status = new TransferStatus();
        if (parent.isExists() && local.exists()) {
            if (file.getType().contains((Object)AbstractPath.Type.file) && local.isDirectory()) {
                throw new LocalAccessDeniedException(String.format("Cannot replace folder %s with file %s", local.getAbbreviatedPath(), file.getName()));
            }
            if (file.getType().contains((Object)AbstractPath.Type.directory) && local.isFile()) {
                throw new LocalAccessDeniedException(String.format("Cannot replace file %s with folder %s", local.getAbbreviatedPath(), file.getName()));
            }
            status.setExists(true);
        }
        if (file.isSymbolicLink()) {
            Path target = file.getSymlinkTarget();
            attributes = this.attribute.find(target);
            if (!this.symlinkResolver.resolve(file) && file.isFile()) {
                status.setLength(attributes.getSize());
            }
        } else {
            attributes = this.attribute.find(file);
            if (file.isFile()) {
                status.setLength(attributes.getSize());
                if (StringUtils.startsWith((CharSequence)attributes.getDisplayname(), (CharSequence)"file:")) {
                    String filename = StringUtils.removeStart((String)attributes.getDisplayname(), (String)"file:");
                    if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)filename)) {
                        status.withDisplayname(LocalFactory.get(local.getParent(), filename));
                        int no = 0;
                        while (status.getDisplayname().local.exists()) {
                            String proposal = String.format("%s-%d", FilenameUtils.getBaseName((String)filename), ++no);
                            if (StringUtils.isNotBlank((CharSequence)FilenameUtils.getExtension((String)filename))) {
                                proposal = proposal + String.format(".%s", FilenameUtils.getExtension((String)filename));
                            }
                            status.withDisplayname(LocalFactory.get(local.getParent(), proposal));
                        }
                    }
                }
            }
        }
        status.setRemote(attributes);
        if (this.options.timestamp) {
            status.setTimestamp(attributes.getModificationDate());
        }
        if (this.options.permissions) {
            Permission permission = Permission.EMPTY;
            if (this.preferences.getBoolean("queue.download.permissions.default")) {
                if (file.isFile()) {
                    permission = new Permission(this.preferences.getInteger("queue.download.permissions.file.default"));
                }
                if (file.isDirectory()) {
                    permission = new Permission(this.preferences.getInteger("queue.download.permissions.folder.default"));
                }
            } else {
                permission = attributes.getPermission();
            }
            status.setPermission(permission);
        }
        status.setAcl(attributes.getAcl());
        if (this.options.segments && file.isFile() && status.getLength() >= this.preferences.getLong("queue.download.segments.threshold") && status.getLength() > this.preferences.getLong("queue.download.segments.size") && (read = this.session.getFeature(Download.class)).offset(file)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Split download %s into segments", local));
            }
            long remaining = status.getLength();
            long offset = 0L;
            long partsize = Math.max(this.preferences.getLong("queue.download.segments.size"), status.getLength() / (long)this.preferences.getInteger("queue.connections.limit"));
            ArrayList<TransferStatus> segments = new ArrayList<TransferStatus>();
            Local segmentsFolder = LocalFactory.get(local.getParent(), String.format("%s.cyberducksegment", local.getName()));
            int segmentNumber = 1;
            while (remaining > 0L) {
                Local segmentFile = LocalFactory.get(segmentsFolder, String.format("%s-%d.cyberducksegment", local.getName(), segmentNumber));
                boolean skip = false;
                Long length = Math.min(partsize, remaining);
                TransferStatus segmentStatus = new TransferStatus().segment(true).append(true).skip(offset).length(length).rename(segmentFile);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Adding status %s for segment %s", segmentStatus, segmentFile));
                }
                segments.add(segmentStatus);
                remaining -= length.longValue();
                offset += length.longValue();
                ++segmentNumber;
            }
            status.withSegments(segments);
        }
        if (this.options.checksum) {
            status.setChecksum(attributes.getChecksum());
        }
        return status;
    }

    @Override
    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
    }

    @Override
    public void complete(Path file, Local local, TransferOptions options, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Complete %s with status %s", file.getAbsolute(), status));
        }
        if (status.isSegment()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skip completion for single segment %s", status));
            }
            return;
        }
        if (status.isComplete()) {
            if (status.isSegmented()) {
                List<TransferStatus> segments = status.getSegments();
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Compile %d segments to file %s", segments.size(), local));
                }
                if (local.exists()) {
                    local.delete();
                }
                Iterator<TransferStatus> iterator = segments.iterator();
                while (iterator.hasNext()) {
                    TransferStatus segmentStatus = iterator.next();
                    Local segmentFile = segmentStatus.getRename().local;
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Append segment %s to %s", segmentFile, local));
                    }
                    segmentFile.copy(local, new Local.CopyOptions().append(true));
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Delete segment %s", segmentFile));
                    }
                    segmentFile.delete();
                    if (iterator.hasNext()) continue;
                    Local folder = segmentFile.getParent();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Remove segment folder %s", folder));
                    }
                    folder.delete();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Run completion for file %s with status %s", local, status));
            }
            if (file.isFile()) {
                DescriptiveUrl provider;
                this.launcher.bounce(local);
                if (this.options.icon) {
                    this.icon.set(local, status);
                    this.icon.remove(local);
                }
                if (!DescriptiveUrl.EMPTY.equals(provider = this.session.getFeature(UrlProvider.class).toUrl(file).find(DescriptiveUrl.Type.provider))) {
                    try {
                        if (options.quarantine) {
                            this.quarantine.setQuarantine(local, new HostUrlProvider().withUsername(false).get(this.session.getHost()), provider.getUrl());
                        }
                        if (this.options.wherefrom) {
                            this.quarantine.setWhereFrom(local, provider.getUrl());
                        }
                    }
                    catch (LocalAccessDeniedException e) {
                        log.warn((Object)String.format("Failure to quarantine file %s. %s", file, e.getMessage()));
                    }
                }
            }
            if (!Permission.EMPTY.equals(status.getPermission())) {
                if (file.isDirectory()) {
                    status.getPermission().setUser(status.getPermission().getUser().or(Permission.Action.read).or(Permission.Action.write).or(Permission.Action.execute));
                }
                if (file.isFile()) {
                    status.getPermission().setUser(status.getPermission().getUser().or(Permission.Action.read).or(Permission.Action.write));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Updating permissions of %s to %s", local, status.getPermission()));
                }
                try {
                    local.attributes().setPermission(status.getPermission());
                }
                catch (AccessDeniedException e) {
                    log.warn((Object)e.getMessage());
                }
            }
            if (status.getTimestamp() != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Updating timestamp of %s to %d", local, status.getTimestamp()));
                }
                try {
                    local.attributes().setModificationDate(status.getTimestamp());
                }
                catch (AccessDeniedException e) {
                    log.warn((Object)e.getMessage());
                }
            }
            if (file.isFile() && this.options.checksum) {
                if (file.getType().contains((Object)AbstractPath.Type.decrypted)) {
                    log.warn((Object)String.format("Skip checksum verification for %s with client side encryption enabled", file));
                } else {
                    Checksum checksum = status.getChecksum();
                    if (Checksum.NONE != checksum) {
                        ChecksumCompute compute = ChecksumComputeFactory.get(checksum.algorithm);
                        listener.message(MessageFormat.format(LocaleFactory.localizedString("Calculate checksum for {0}", "Status"), file.getName()));
                        Checksum download = compute.compute(local.getInputStream(), new TransferStatus());
                        if (!checksum.equals(download)) {
                            throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString("Download {0} failed", "Error"), file.getName()), MessageFormat.format(LocaleFactory.localizedString("Mismatch between {0} hash {1} of downloaded data and checksum {2} returned by the server", "Error"), download.algorithm.toString(), download.hash, checksum.hash));
                        }
                    }
                }
            }
            if (file.isFile()) {
                if (status.getDisplayname().local != null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Rename file %s to %s", file, status.getDisplayname().local));
                    }
                    local.rename(status.getDisplayname().local);
                }
                if (options.open) {
                    this.launcher.open(local);
                }
            }
        }
    }
}

