/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.unicode.NFCNormalizer;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public final class PathNormalizer {
    private static final boolean enabled = PreferencesFactory.get().getBoolean("path.normalize");
    private static final boolean nfc = PreferencesFactory.get().getBoolean("path.normalize.unicode");

    private PathNormalizer() {
    }

    public static String name(String path) {
        if (String.valueOf('/').equals(path)) {
            return path;
        }
        if (StringUtils.endsWith((CharSequence)path, (CharSequence)String.valueOf('/'))) {
            return FilenameUtils.getName((String)PathNormalizer.normalize(path));
        }
        return FilenameUtils.getName((String)path);
    }

    public static String parent(String absolute, char delimiter) {
        int cut;
        if (String.valueOf(delimiter).equals(absolute)) {
            return null;
        }
        int index = absolute.length() - 1;
        if (absolute.charAt(index) == delimiter && index > 0) {
            --index;
        }
        if ((cut = absolute.lastIndexOf(delimiter, index)) > 0) {
            return absolute.substring(0, cut);
        }
        return String.valueOf(delimiter);
    }

    public static String normalize(String path) {
        return PathNormalizer.normalize(path, true);
    }

    public static String normalize(String path, boolean absolute) {
        if (null == path) {
            return String.valueOf('/');
        }
        String normalized = path;
        if (enabled) {
            String[] segments;
            int index;
            if (absolute) {
                while (!normalized.startsWith(String.valueOf('/'))) {
                    normalized = '/' + normalized;
                }
            }
            while (!normalized.endsWith(String.valueOf('/'))) {
                normalized = normalized + '/';
            }
            while ((index = normalized.indexOf("/./")) >= 0) {
                normalized = normalized.substring(0, index) + normalized.substring(index + 2);
            }
            while ((index = normalized.indexOf("/../")) >= 0) {
                if (index == 0) {
                    return String.valueOf('/');
                }
                normalized = normalized.substring(0, normalized.lastIndexOf(47, index - 1)) + normalized.substring(index + 3);
            }
            StringBuilder n = new StringBuilder();
            if (normalized.startsWith("//")) {
                n.append('/');
                n.append('/');
            } else if (absolute) {
                n.append('/');
            } else if (normalized.startsWith(String.valueOf('/'))) {
                n.append('/');
            }
            for (String segment : segments = StringUtils.split((String)normalized, (String)String.valueOf('/'))) {
                if (segment.equals("")) continue;
                n.append(segment);
                n.append('/');
            }
            normalized = n.toString();
            while (normalized.endsWith(String.valueOf('/')) && normalized.length() > 1) {
                normalized = normalized.substring(0, normalized.length() - 1);
            }
        }
        if (nfc) {
            return new NFCNormalizer().normalize(normalized).toString();
        }
        return normalized;
    }

    public static List<Path> normalize(List<Path> selected) {
        Collection<Path> normalized = new Collection<Path>();
        for (Path f : selected) {
            boolean duplicate = false;
            for (Path n : normalized) {
                if (!f.isChild(n)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            normalized.add(f);
        }
        return normalized;
    }
}

