/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.EditableCollection;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.FolderBookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import org.apache.log4j.Logger;

public class MultipleFolderBookmarkCollection
extends Collection<FolderBookmarkCollection>
implements EditableCollection {
    private static final Logger log = Logger.getLogger(FolderBookmarkCollection.class);
    private static final MultipleFolderBookmarkCollection EMPTY = new MultipleFolderBookmarkCollection(null){
        private static final long serialVersionUID = 5741322275377145083L;

        @Override
        public void load() {
        }
    };
    private static final long serialVersionUID = -6318679625583371126L;
    private static final MultipleFolderBookmarkCollection DEFAULT_COLLECTION = new MultipleFolderBookmarkCollection(LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "Bookmarks"));
    private final Local folder;

    public static MultipleFolderBookmarkCollection empty() {
        return EMPTY;
    }

    public static MultipleFolderBookmarkCollection defaultCollection() {
        return DEFAULT_COLLECTION;
    }

    public MultipleFolderBookmarkCollection(Local f) {
        this.folder = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws AccessDeniedException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Reloading %s", this.folder));
        }
        this.lock();
        try {
            if (!this.folder.exists()) {
                new DefaultLocalDirectoryFeature().mkdir(this.folder);
            }
            AttributedList<Local> groups = this.folder.list().filter((Filter<Local>)new NullFilter<Local>(){

                @Override
                public boolean accept(Local file) {
                    return file.isDirectory();
                }
            });
            for (Local group : groups) {
                this.add(new FolderBookmarkCollection(group, group.getName()));
            }
        }
        finally {
            this.unlock();
        }
        super.load();
    }

    public boolean contains(Host bookmark) {
        for (AbstractHostCollection c : this) {
            if (!c.contains(bookmark)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsAdd() {
        for (AbstractHostCollection c : this) {
            if (c.allowsAdd()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allowsDelete() {
        for (AbstractHostCollection c : this) {
            if (c.allowsDelete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allowsEdit() {
        for (AbstractHostCollection c : this) {
            if (c.allowsEdit()) continue;
            return false;
        }
        return true;
    }
}

