/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentWeakIdentityHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<WeakReference<K>, V> map = new ConcurrentHashMap<WeakReference<K>, V>();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    @Override
    public V putIfAbsent(K key, V value) {
        this.purgeKeys();
        return this.map.putIfAbsent(this.newKey(key), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.purgeKeys();
        return this.map.remove(new WeakReference(key, null), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.purgeKeys();
        return this.map.replace(this.newKey(key), oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        this.purgeKeys();
        return this.map.replace(this.newKey(key), value);
    }

    @Override
    public int size() {
        this.purgeKeys();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.purgeKeys();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.purgeKeys();
        return this.map.containsKey(new WeakReference(key, null));
    }

    @Override
    public boolean containsValue(Object value) {
        this.purgeKeys();
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.purgeKeys();
        return this.map.get(new WeakReference(key, null));
    }

    @Override
    public V put(K key, V value) {
        this.purgeKeys();
        return this.map.put(this.newKey(key), value);
    }

    @Override
    public V remove(Object key) {
        this.purgeKeys();
        return this.map.remove(new WeakReference(key, null));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.purgeKeys();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.map.put(this.newKey(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.purgeKeys();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                ConcurrentWeakIdentityHashMap.this.purgeKeys();
                return new WeakSafeIterator<K, WeakReference<K>>(ConcurrentWeakIdentityHashMap.this.map.keySet().iterator()){

                    @Override
                    protected K extract(WeakReference<K> u) {
                        return u.get();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return ConcurrentWeakIdentityHashMap.this.containsKey(o);
            }

            @Override
            public int size() {
                return ConcurrentWeakIdentityHashMap.this.map.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        this.purgeKeys();
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                ConcurrentWeakIdentityHashMap.this.purgeKeys();
                return new WeakSafeIterator<Map.Entry<K, V>, Map.Entry<WeakReference<K>, V>>(ConcurrentWeakIdentityHashMap.this.map.entrySet().iterator()){

                    @Override
                    protected Map.Entry<K, V> extract(Map.Entry<WeakReference<K>, V> u) {
                        Object key = u.getKey().get();
                        if (key == null) {
                            return null;
                        }
                        return new AbstractMap.SimpleEntry(key, u.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return ConcurrentWeakIdentityHashMap.this.map.size();
            }
        };
    }

    private void purgeKeys() {
        Reference<K> reference;
        while ((reference = this.queue.poll()) != null) {
            this.map.remove(reference);
        }
    }

    private WeakReference<K> newKey(K key) {
        return new WeakReference(key, this.queue);
    }

    private static abstract class WeakSafeIterator<T, U>
    implements Iterator<T> {
        private final Iterator<U> weakIterator;
        protected T strongNext;

        public WeakSafeIterator(Iterator<U> weakIterator) {
            this.weakIterator = weakIterator;
            this.advance();
        }

        private void advance() {
            while (this.weakIterator.hasNext()) {
                U nextU = this.weakIterator.next();
                this.strongNext = this.extract(nextU);
                if (this.strongNext == null) continue;
                return;
            }
            this.strongNext = null;
        }

        @Override
        public boolean hasNext() {
            return this.strongNext != null;
        }

        @Override
        public final T next() {
            T next = this.strongNext;
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract T extract(U var1);
    }

    private static class WeakReference<T>
    extends java.lang.ref.WeakReference<T> {
        private final int hashCode;

        private WeakReference(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.hashCode = referent.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass() && (this == obj || this.get() == ((WeakReference)obj).get());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

