/*
 * Decompiled with CFR 0.152.
 */
package io.mikael.urlbuilder.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class UrlParameterMultimap
implements Map<String, List<String>> {
    private final List<Map.Entry<String, String>> data;

    private UrlParameterMultimap(List<Map.Entry<String, String>> data) {
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    private static Map.Entry<String, String> newEntry(String key, String value) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    public static UrlParameterMultimap newMultimap() {
        return new UrlParameterMultimap(new LinkedList<Map.Entry<String, String>>());
    }

    public UrlParameterMultimap deepCopy() {
        return new UrlParameterMultimap(new LinkedList<Map.Entry<String, String>>(this.data));
    }

    public Immutable immutable() {
        if (this instanceof Immutable) {
            return (Immutable)this;
        }
        return new Immutable(this.data);
    }

    @Override
    public boolean containsKey(Object key) {
        if (null == key) {
            throw new IllegalArgumentException("key can't be null");
        }
        for (Map.Entry<String, String> e : this.data) {
            if (!key.equals(e.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (null == value) {
            throw new IllegalArgumentException("value can't be null");
        }
        for (Map.Entry<String, String> e : this.data) {
            if (!value.equals(e.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> get(Object key) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.data) {
            if (!key.equals(e.getKey())) continue;
            ret.add(e.getValue());
        }
        return ret.isEmpty() ? null : ret;
    }

    public UrlParameterMultimap add(String key, String value) {
        this.data.add(UrlParameterMultimap.newEntry(key, value));
        return this;
    }

    public UrlParameterMultimap replaceValues(String key, String value) {
        this.remove(key);
        this.add(key, value);
        return this;
    }

    @Override
    public List<String> put(String key, List<String> value) {
        ArrayList<String> overflow = new ArrayList<String>(value);
        ListIterator<Map.Entry<String, String>> it = this.data.listIterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            if (key.equals(e.getKey()) && value.contains(e.getValue())) {
                overflow.remove(e.getValue());
                continue;
            }
            if (!key.equals(e.getKey())) continue;
            it.remove();
        }
        for (String v : overflow) {
            this.add(key, v);
        }
        return null;
    }

    @Override
    public List<String> remove(Object key) {
        if (null == key) {
            throw new IllegalArgumentException("can't remove null");
        }
        ArrayList<String> ret = new ArrayList<String>();
        ListIterator<Map.Entry<String, String>> it = this.data.listIterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            if (!key.equals(e.getKey())) continue;
            ret.add(e.getValue());
            it.remove();
        }
        return ret;
    }

    public UrlParameterMultimap removeAllValues(String key) {
        this.remove(key);
        return this;
    }

    public UrlParameterMultimap remove(String key, String value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("can't remove null");
        }
        ListIterator<Map.Entry<String, String>> it = this.data.listIterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            if (!key.equals(e.getKey()) || !value.equals(e.getValue())) continue;
            it.remove();
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m) {
        for (Map.Entry<? extends String, ? extends List<String>> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, String> e : this.data) {
            ret.add(e.getKey());
        }
        return ret;
    }

    public List<Map.Entry<String, String>> flatEntryList() {
        return this.data;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        LinkedHashMap entries = new LinkedHashMap();
        for (Map.Entry<String, String> entry : this.data) {
            if (!entries.containsKey(entry.getKey())) {
                entries.put(entry.getKey(), new LinkedList());
            }
            ((List)entries.get(entry.getKey())).add(entry.getValue());
        }
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            entry.setValue((String)((Object)Collections.unmodifiableList((List)((Object)entry.getValue()))));
        }
        return Collections.unmodifiableSet(entries.entrySet());
    }

    @Override
    public Collection<List<String>> values() {
        LinkedList<List<String>> ret = new LinkedList<List<String>>();
        for (Map.Entry<String, List<String>> e : this.entrySet()) {
            ret.add(e.getValue());
        }
        return Collections.unmodifiableList(ret);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UrlParameterMultimap)) {
            return false;
        }
        UrlParameterMultimap otherMultimap = (UrlParameterMultimap)other;
        return this.data.equals(otherMultimap.data);
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    public static final class Immutable
    extends UrlParameterMultimap {
        Immutable(List<Map.Entry<String, String>> data) {
            super(Collections.unmodifiableList(new LinkedList<Map.Entry<String, String>>(data)));
        }
    }
}

