/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3Session;

public class GoogleStorageListService
implements ListService {
    private final GoogleStorageSession session;

    public GoogleStorageListService(GoogleStorageSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            return new S3BucketListService((S3Session)this.session, new S3LocationFeature.S3Region(this.session.getHost().getRegion())).list(directory, listener);
        }
        return new S3ObjectListService((S3Session)this.session).list(directory, listener);
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

