/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class LocalProtocol
extends AbstractProtocol {
    private static String LOCAL_HOSTNAME;

    public String getIdentifier() {
        return this.getScheme().name();
    }

    public String getName() {
        return LOCAL_HOSTNAME;
    }

    public String getDescription() {
        return this.getName();
    }

    public String getPrefix() {
        return String.format("%s.%s", LocalProtocol.class.getPackage().getName(), "Local");
    }

    public Scheme getScheme() {
        return Scheme.file;
    }

    public boolean isEncodingConfigurable() {
        return true;
    }

    public Protocol.Type getType() {
        return Protocol.Type.file;
    }

    public boolean isHostnameConfigurable() {
        return false;
    }

    public boolean isPortConfigurable() {
        return false;
    }

    public boolean isUsernameConfigurable() {
        return false;
    }

    public boolean isPasswordConfigurable() {
        return false;
    }

    public String getDefaultHostname() {
        return InetAddress.getLoopbackAddress().getHostName();
    }

    public String disk() {
        switch (Factory.Platform.getDefault()) {
            case mac: {
                return "NSComputer";
            }
        }
        return super.disk();
    }

    static {
        try {
            LOCAL_HOSTNAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOCAL_HOSTNAME = LocaleFactory.localizedString((String)"Disk");
        }
    }
}

