/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature;

import com.joyent.http.signature.CryptoException;
import com.joyent.http.signature.KeyFingerprinter;
import com.joyent.http.signature.KeyPairLoader;
import com.joyent.http.signature.crypto.NativeRSAProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.bouncycastle.util.encoders.Base64;

public class Signer {
    @Deprecated
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy zzz", Locale.ENGLISH);
    private static final String AUTHZ_HEADER = "Signature keyId=\"/%s/keys/%s\",algorithm=\"%s\",signature=\"%s\"";
    private static final String AUTHZ_SIGNING_STRING = "date: %s";
    private static final String AUTHZ_PATTERN = "signature=\"";
    private final Signature signature;
    private final String httpHeaderAlgorithm;

    @Deprecated
    public Signer() {
        this(true);
    }

    @Deprecated
    public Signer(boolean useNativeCodeToSign) {
        this(new Builder("RSA").providerCode(useNativeCodeToSign ? "native.jnagmp" : "stdlib"));
    }

    public Signer(Builder builder) {
        Provider provider = builder.algHelper.makeProvider(builder.providerCode);
        this.httpHeaderAlgorithm = builder.httpHeaderAlgorithm();
        if (provider == null) {
            try {
                this.signature = Signature.getInstance(builder.javaStandardName(provider));
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new CryptoException(nsae);
            }
        }
        try {
            this.signature = Signature.getInstance(builder.javaStandardName(provider), provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CryptoException(nsae);
        }
    }

    @Deprecated
    public KeyPair getKeyPair(Path keyPath) throws IOException {
        return KeyPairLoader.getKeyPair(keyPath);
    }

    @Deprecated
    public KeyPair getKeyPair(String privateKeyContent, char[] password) throws IOException {
        return KeyPairLoader.getKeyPair(privateKeyContent, password);
    }

    @Deprecated
    public KeyPair getKeyPair(byte[] pKeyBytes, char[] password) throws IOException {
        return KeyPairLoader.getKeyPair(pKeyBytes, password);
    }

    @Deprecated
    public KeyPair getKeyPair(InputStream is, char[] password) throws IOException {
        return KeyPairLoader.getKeyPair(is, password);
    }

    @Deprecated
    public String createAuthorizationHeader(String login, String fingerprint, KeyPair keyPair) {
        return this.createAuthorizationHeader(login, keyPair, this.defaultSignDateAsString());
    }

    public String createAuthorizationHeader(String login, KeyPair keyPair) {
        return this.createAuthorizationHeader(login, keyPair, this.defaultSignDateAsString());
    }

    @Deprecated
    public String createAuthorizationHeader(String login, String fingerprint, KeyPair keyPair, Date date) {
        return this.createAuthorizationHeader(login, keyPair, date);
    }

    @Deprecated
    public String createAuthorizationHeader(String login, KeyPair keyPair, Date date) {
        ZonedDateTime zdt = date == null ? null : ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        return this.createAuthorizationHeader(login, keyPair, zdt);
    }

    public String createAuthorizationHeader(String login, KeyPair keyPair, ZonedDateTime dateTime) {
        String stringDate = dateTime == null ? this.defaultSignDateAsString() : DateTimeFormatter.RFC_1123_DATE_TIME.format(dateTime);
        return this.createAuthorizationHeader(login, keyPair, stringDate);
    }

    @Deprecated
    public String createAuthorizationHeader(String login, String fingerprint, KeyPair keyPair, String date) {
        Objects.requireNonNull(login, "Login must be present");
        Objects.requireNonNull(keyPair, "Keypair must be present");
        return this.createAuthorizationHeader(login, keyPair, date);
    }

    public String createAuthorizationHeader(String login, KeyPair keyPair, String date) {
        Objects.requireNonNull(login, "Login must be present");
        Objects.requireNonNull(keyPair, "Keypair must be present");
        try {
            this.signature.initSign(keyPair.getPrivate());
            String signingString = String.format(AUTHZ_SIGNING_STRING, date);
            this.signature.update(signingString.getBytes(StandardCharsets.UTF_8));
            byte[] signedDate = this.signature.sign();
            byte[] encodedSignedDate = Base64.encode((byte[])signedDate);
            String fingerprint = KeyFingerprinter.md5Fingerprint(keyPair);
            return String.format(AUTHZ_HEADER, login, fingerprint, this.httpHeaderAlgorithm, new String(encodedSignedDate, StandardCharsets.US_ASCII));
        }
        catch (InvalidKeyException e) {
            throw new CryptoException("invalid key", e);
        }
        catch (SignatureException e) {
            throw new CryptoException("invalid signature", e);
        }
    }

    @Deprecated
    public byte[] sign(String login, String fingerprint, KeyPair keyPair, byte[] data) {
        return this.sign(login, keyPair, data);
    }

    public byte[] sign(String login, KeyPair keyPair, byte[] data) {
        Objects.requireNonNull(login, "Login must be present");
        Objects.requireNonNull(keyPair, "Keypair must be present");
        Objects.requireNonNull(data, "Data must be present");
        try {
            this.signature.initSign(keyPair.getPrivate());
            this.signature.update(data);
            return this.signature.sign();
        }
        catch (InvalidKeyException e) {
            throw new CryptoException("invalid key", e);
        }
        catch (SignatureException e) {
            throw new CryptoException("invalid signature", e);
        }
    }

    @Deprecated
    public boolean verify(String login, String fingerprint, KeyPair keyPair, byte[] data, byte[] signedData) {
        return this.verify(login, keyPair, data, signedData);
    }

    public boolean verify(String login, KeyPair keyPair, byte[] data, byte[] signedData) {
        Objects.requireNonNull(login, "Login must be present");
        Objects.requireNonNull(keyPair, "Keypair must be present");
        Objects.requireNonNull(signedData, "Data must be present");
        try {
            this.signature.initVerify(keyPair.getPublic());
            this.signature.update(data);
            return this.signature.verify(signedData);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException("invalid key", e);
        }
        catch (SignatureException e) {
            throw new CryptoException("invalid signature", e);
        }
    }

    public String defaultSignDateAsString() {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC));
    }

    public boolean verifyAuthorizationHeader(KeyPair keyPair, String authzHeader, String date) {
        Objects.requireNonNull(keyPair, "Keypair must be present");
        Objects.requireNonNull(authzHeader, "AuthzHeader must be present");
        Objects.requireNonNull(date, "Date must be present");
        String myDate = String.format(AUTHZ_SIGNING_STRING, date);
        try {
            this.signature.initVerify(keyPair.getPublic());
            int startIndex = authzHeader.indexOf(AUTHZ_PATTERN);
            if (startIndex == -1) {
                throw new CryptoException(String.format("invalid authorization header %s", authzHeader));
            }
            String encodedSignedDate = authzHeader.substring(startIndex + AUTHZ_PATTERN.length(), authzHeader.length() - 1);
            byte[] signedDate = Base64.decode((byte[])encodedSignedDate.getBytes(StandardCharsets.UTF_8));
            this.signature.update(myDate.getBytes(StandardCharsets.UTF_8));
            return this.signature.verify(signedDate);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException("invalid key", e);
        }
        catch (SignatureException e) {
            throw new CryptoException("invalid signature", e);
        }
    }

    public String getHttpHeaderAlgorithm() {
        return this.httpHeaderAlgorithm;
    }

    Signature getSignature() {
        return this.signature;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Signer{");
        sb.append("signature=").append(this.signature);
        sb.append(",provider=").append(this.signature.getProvider().getName());
        sb.append(",httpHeaderAlgorithm=").append(this.httpHeaderAlgorithm);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private final SigningAlgorithmHelper algHelper;
        private String hash;
        private String providerCode;

        public Builder(KeyPair keyPair) {
            this.algHelper = SigningAlgorithmHelper.create(keyPair);
            this.hash = this.algHelper.defaultHash();
            this.providerCode = this.algHelper.defaultProviderCode();
        }

        public Builder(String algorithm) {
            this.algHelper = SigningAlgorithmHelper.create(algorithm);
            this.hash = this.algHelper.defaultHash();
            this.providerCode = this.algHelper.defaultProviderCode();
        }

        public Builder hash(String hash) {
            this.algHelper.checkSupportedHash(hash);
            this.hash = hash;
            return this;
        }

        public Builder providerCode(String providerCode) {
            this.algHelper.checkSupportedProviderCode(providerCode);
            this.providerCode = providerCode;
            return this;
        }

        private String javaStandardName(Provider provider) {
            return this.hash + "with" + this.algHelper.providerPrefix(provider) + this.algHelper.getAlgorithm();
        }

        private String httpHeaderAlgorithm() {
            return this.algHelper.getAlgorithm().toLowerCase() + "-" + this.hash.toLowerCase();
        }

        public Signer build() {
            return new Signer(this);
        }

        private static class EcdsaHelper
        extends SigningAlgorithmHelper {
            private static final String[] SUPPORTED_HASHES = new String[]{"SHA256", "SHA384", "SHA512"};
            private static final String[] SUPPORTED_PROVIDER_CODES = new String[]{"stdlib"};

            private EcdsaHelper() {
            }

            @Override
            public String getAlgorithm() {
                return "ECDSA";
            }

            @Override
            public String[] getSupportedHashes() {
                return SUPPORTED_HASHES;
            }

            @Override
            public String defaultHash() {
                return "SHA256";
            }

            @Override
            public String[] getSupportedProviderCodes() {
                return SUPPORTED_PROVIDER_CODES;
            }

            @Override
            public String defaultProviderCode() {
                return "stdlib";
            }
        }

        private static class DsaHelper
        extends SigningAlgorithmHelper {
            private static final String[] SUPPORTED_HASHES = new String[]{"SHA1", "SHA256"};
            private static final String[] SUPPORTED_PROVIDER_CODES = new String[]{"stdlib"};

            private DsaHelper() {
            }

            @Override
            public String getAlgorithm() {
                return "DSA";
            }

            @Override
            public String[] getSupportedHashes() {
                return SUPPORTED_HASHES;
            }

            @Override
            public String defaultHash() {
                return "SHA256";
            }

            @Override
            public String[] getSupportedProviderCodes() {
                return SUPPORTED_PROVIDER_CODES;
            }

            @Override
            public String defaultProviderCode() {
                return "stdlib";
            }
        }

        private static class RsaHelper
        extends SigningAlgorithmHelper {
            private static final String[] SUPPORTED_HASHES = new String[]{"SHA1", "SHA256", "SHA512"};
            private static final String[] SUPPORTED_PROVIDER_CODES = new String[]{"native.jnagmp", "stdlib"};
            private static final String[] SUPPORTED_NATIVE_OS = new String[]{"linux", "mac os x", "sunos"};
            private static final String[] SUPPORTED_NATIVE_ARCH = new String[]{"amd64", "x86_64"};
            private static final boolean JNAGMP_SUPPORTED;

            private RsaHelper() {
            }

            @Override
            public String getAlgorithm() {
                return "RSA";
            }

            @Override
            public String[] getSupportedHashes() {
                return SUPPORTED_HASHES;
            }

            @Override
            public String defaultHash() {
                return "SHA256";
            }

            @Override
            public String[] getSupportedProviderCodes() {
                return SUPPORTED_PROVIDER_CODES;
            }

            @Override
            public String defaultProviderCode() {
                return "native.jnagmp";
            }

            @Override
            public String providerPrefix(Provider provider) {
                if (provider != null) {
                    return "Native";
                }
                return "";
            }

            @Override
            public Provider makeProvider(String providerCode) {
                if (providerCode.equals("native.jnagmp") && JNAGMP_SUPPORTED) {
                    try {
                        return new NativeRSAProvider();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                return null;
            }

            static {
                String os = System.getProperty("os.name").toLowerCase();
                String arch = System.getProperty("os.arch").toLowerCase();
                JNAGMP_SUPPORTED = Arrays.binarySearch(SUPPORTED_NATIVE_OS, os) >= 0 && Arrays.binarySearch(SUPPORTED_NATIVE_ARCH, arch) >= 0;
                System.setProperty("native.jnagmp", Objects.toString(JNAGMP_SUPPORTED));
            }
        }

        private static abstract class SigningAlgorithmHelper {
            private SigningAlgorithmHelper() {
            }

            public static SigningAlgorithmHelper create(KeyPair keyPair) {
                return SigningAlgorithmHelper.create(keyPair.getPrivate().getAlgorithm());
            }

            public static SigningAlgorithmHelper create(String algorithm) {
                if (algorithm.equals("RSA")) {
                    return new RsaHelper();
                }
                if (algorithm.equals("DSA")) {
                    return new DsaHelper();
                }
                if (algorithm.equals("ECDSA") || algorithm.equals("EC")) {
                    return new EcdsaHelper();
                }
                throw new IllegalArgumentException("invalid signing algorithm: " + algorithm);
            }

            public abstract String getAlgorithm();

            public abstract String[] getSupportedHashes();

            public abstract String defaultHash();

            public abstract String[] getSupportedProviderCodes();

            public abstract String defaultProviderCode();

            public void checkSupportedHash(String hash) {
                if (Arrays.binarySearch(this.getSupportedHashes(), hash) == -1) {
                    throw new IllegalArgumentException("invalid hash algorithm: " + hash);
                }
            }

            public void checkSupportedProviderCode(String providerCode) {
                if (Arrays.binarySearch(this.getSupportedProviderCodes(), providerCode) == -1) {
                    throw new IllegalArgumentException("invalid providerCode algorithm: " + providerCode);
                }
            }

            public String providerPrefix(Provider provider) {
                return "";
            }

            public Provider makeProvider(String providerCode) {
                return null;
            }
        }
    }
}

