/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AbstractListService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.S3Version;

public class S3VersionedObjectListService
extends S3AbstractListService
implements ListService {
    private static final Logger log = Logger.getLogger(S3VersionedObjectListService.class);
    public static final String KEY_DELETE_MARKER = "delete_marker";
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final Integer concurrency;

    public S3VersionedObjectListService(S3Session session) {
        this(session, PreferencesFactory.get().getInteger("s3.listing.concurrency"));
    }

    public S3VersionedObjectListService(S3Session session, Integer concurrency) {
        this.session = session;
        this.concurrency = concurrency;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"list", (int)this.concurrency);
        try {
            String prefix = this.createPrefix(directory);
            Path bucket = this.containerService.getContainer(directory);
            AttributedList children = new AttributedList();
            ArrayList<Future<Path>> folders = new ArrayList<Future<Path>>();
            String priorLastKey = null;
            String priorLastVersionId = null;
            long revision = 0L;
            String lastKey = null;
            do {
                String[] stringArray;
                VersionOrDeleteMarkersChunk chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(bucket.getName(), prefix, String.valueOf('/'), this.preferences.getInteger("s3.listing.chunksize"), priorLastKey, priorLastVersionId, true);
                for (BaseVersionOrDeleteMarker marker : chunk.getItems()) {
                    String key = PathNormalizer.normalize((String)marker.getKey());
                    if (String.valueOf('/').equals(key)) {
                        log.warn((Object)String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    PathAttributes attributes = new PathAttributes();
                    attributes.setVersionId("null".equals(marker.getVersionId()) ? null : marker.getVersionId());
                    if (!StringUtils.equals(lastKey, (CharSequence)key)) {
                        revision = 0L;
                    }
                    attributes.setRevision(Long.valueOf(++revision));
                    attributes.setDuplicate(marker.isDeleteMarker() && marker.isLatest() || !marker.isLatest());
                    if (marker.isDeleteMarker()) {
                        attributes.setCustom(Collections.singletonMap(KEY_DELETE_MARKER, Boolean.TRUE.toString()));
                    }
                    attributes.setModificationDate(marker.getLastModified().getTime());
                    attributes.setRegion(bucket.attributes().getRegion());
                    if (marker instanceof S3Version) {
                        S3Version object = (S3Version)marker;
                        attributes.setSize(object.getSize());
                        if (StringUtils.isNotBlank((CharSequence)object.getEtag())) {
                            attributes.setETag(object.getEtag());
                        }
                        if (StringUtils.isNotBlank((CharSequence)object.getStorageClass())) {
                            attributes.setStorageClass(object.getStorageClass());
                        }
                    }
                    Path f = new Path(directory, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.file), attributes);
                    children.add((Referenceable)f);
                    lastKey = key;
                }
                for (String common : stringArray = chunk.getCommonPrefixes()) {
                    if (String.valueOf('/').equals(common)) {
                        log.warn((Object)String.format("Skipping prefix %s", common));
                        continue;
                    }
                    String key = PathNormalizer.normalize((String)common);
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    folders.add(this.submit(pool, bucket, common));
                }
                priorLastKey = chunk.getNextKeyMarker();
                priorLastVersionId = chunk.getNextVersionIdMarker();
                listener.chunk(directory, children);
            } while (priorLastKey != null);
            for (Future future : folders) {
                try {
                    children.add((Referenceable)future.get());
                }
                catch (InterruptedException e) {
                    log.error((Object)"Listing versioned objects failed with interrupt failure");
                    throw new ConnectionCanceledException((Throwable)e);
                }
                catch (ExecutionException e) {
                    log.warn((Object)String.format("Listing versioned objects failed with execution failure %s", e.getMessage()));
                    if (e.getCause() instanceof BackgroundException) {
                        throw (BackgroundException)e.getCause();
                    }
                    throw new BackgroundException(e.getCause());
                }
            }
            AttributedList attributedList = children;
            return attributedList;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        finally {
            pool.shutdown(false);
        }
    }

    private Future<Path> submit(ThreadPool pool, final Path bucket, final String common) {
        return pool.execute((Callable)new BackgroundExceptionCallable<Path>(){

            public Path call() throws BackgroundException {
                PathAttributes attributes = new PathAttributes();
                attributes.setRegion(bucket.attributes().getRegion());
                Path prefix = new Path(String.format("%s%s", bucket.getAbsolute(), PathNormalizer.normalize((String)common)), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
                try {
                    VersionOrDeleteMarkersChunk versions = ((RequestEntityRestStorageService)((Object)S3VersionedObjectListService.this.session.getClient())).listVersionedObjectsChunked(bucket.getName(), common, String.valueOf('/'), 1L, null, null, false);
                    if (versions.getItems().length == 1) {
                        BaseVersionOrDeleteMarker version = versions.getItems()[0];
                        if (version.getKey().equals(common)) {
                            attributes.setVersionId("null".equals(version.getVersionId()) ? null : version.getVersionId());
                            if (version.isDeleteMarker()) {
                                attributes.setCustom((Map)ImmutableMap.of((Object)S3VersionedObjectListService.KEY_DELETE_MARKER, (Object)Boolean.TRUE.toString()));
                                attributes.setDuplicate(true);
                            }
                        } else {
                            StorageObjectsChunk unversioned = ((RequestEntityRestStorageService)((Object)S3VersionedObjectListService.this.session.getClient())).listObjectsChunked(bucket.getName(), common, "", 1L, null, false);
                            if (unversioned.getObjects().length == 0) {
                                attributes.setDuplicate(true);
                            }
                        }
                    }
                }
                catch (ServiceException e) {
                    throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, prefix);
                }
                return prefix;
            }
        });
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

