/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.testutils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.irods.jargon.core.connection.AuthScheme;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.testutils.TestingUtilsException;

public class TestingPropertiesHelper {
    public static final String IRODS_GSI_HOST_KEY = "test.option.gsi.host";
    public static final String IRODS_GSI_PORT_KEY = "test.option.gsi.port";
    public static final String IRODS_GSI_ZONE_KEY = "test.option.gsi.zone";
    public static final String IRODS_GSI_DN_KEY = "test.option.gsi.dn";
    public static final String IRODS_GSI_CERT_PATH = "test.option.gsi.file";
    public static String GENERATED_FILE_DIRECTORY_KEY = "test.data.directory";
    public static String IRODS_USER_KEY = "test.irods.user";
    public static String IRODS_PASSWORD_KEY = "test.irods.password";
    public static String IRODS_RESOURCE_KEY = "test.irods.resource";
    public static String IRODS_USER_DN_KEY = "test.irods.userDN";
    public static String IRODS_SECONDARY_USER_KEY = "test2.irods.user";
    public static String IRODS_SECONDARY_PASSWORD_KEY = "test2.irods.password";
    public static String IRODS_SECONDARY_RESOURCE_KEY = "test2.irods.resource";
    public static String IRODS_TERTIARY_USER_KEY = "test3.irods.user";
    public static String IRODS_TERTIARY_PASSWORD_KEY = "test3.irods.password";
    public static String IRODS_TERTIARY_RESOURCE_KEY = "test3.irods.resource";
    public static String IRODS_HOST_KEY = "test.irods.host";
    public static String IRODS_RESOURCE_HOST_KEY = "test.irods.resource.host";
    public static String IRODS_PORT_KEY = "test.irods.port";
    public static String IRODS_ZONE_KEY = "test.irods.zone";
    public static String IRODS_SCRATCH_DIR_KEY = "test.irods.scratch.subdir";
    public static String IRODS_CONFIRM_TESTING_KEY = "test.confirm";
    public static String IRODS_ADMIN_USER_KEY = "test.irods.admin";
    public static String IRODS_ADMIN_PASSWORD_KEY = "test.irods.admin.password";
    public static String IRODS_RESOURCE_GROUP_KEY = "test.resource.group";
    public static String IRODS_USER_GROUP_KEY = "jargon.test.user.group";
    public static String IRODS_TEST_FEDERATED_ZONE_KEY = "test.option.federated.zone";
    public static String IRODS_TEST_OPTION_KERBEROS_KEY = "test.option.kerberos";
    public static String IRODS_TEST_OPTION_REG_FILESYSTEM = "test.option.exercise.filesystem.reg";
    public static String IRODS_TEST_OPTION_REG_FILESYSTEM_LOCAL = "test.option.exercise.filesystem.reg.local";
    public static String IRODS_REG_BASEDIR = "test.option.mount.basedir";
    public static String IRODS_FEDERATED_HOST_KEY = "test.federated.irods.host";
    public static String IRODS_FEDERATED_PORT_KEY = "test.federated.irods.port";
    public static String IRODS_FEDERATED_ZONE_KEY = "test.federated.irods.zone";
    public static String IRODS_FEDERATED_RESOURCE_KEY = "test.federated.irods.resource";
    public static String IRODS_FEDERATED_USER_KEY = "test.federated.irods.user";
    public static String IRODS_FEDERATED_PASSWORD_KEY = "test.federated.irods.password";
    public static String IRODS_FEDERATED_ADMIN_USER_KEY = "test.federated.irods.admin";
    public static String IRODS_FEDERATED_ADMIN_PASSWORD_KEY = "test.federated.irods.admin.password";
    public static String IRODS_KERBEROS_USER_KEY = "jargon.test.kerberos.user";
    public static String IRODS_TEST_OPTION_PAM_KEY = "test.option.pam";
    public static String IRODS_TEST_OPTION_SSL_KEY = "test.option.ssl.configured";
    public static String IRODS_TEST_OPTION_EXERCISE_WORKFLOW = "test.option.exercise.workflow";
    public static String IRODS_PAM_USER_KEY = "jargon.test.pam.user";
    public static String IRODS_PAM_PASSWORD_KEY = "jargon.test.pam.password";
    public static String IRODS_CONFIRM_TESTING_TRUE = "true";
    public static String IRODS_CONFIRM_TESTING_FALSE = "false";
    public static String IRODS_TEST_OPTION_EIRODS = "test.option.eirods";

    public int getPropertyValueAsInt(Properties testingProperties, String key) throws TestingUtilsException {
        String propVal = (String)testingProperties.get(key);
        if (propVal == null || propVal.length() == 0) {
            throw new TestingUtilsException("missing or invalid value in testing.properties");
        }
        int retVal = 0;
        try {
            retVal = Integer.parseInt(propVal);
        }
        catch (NumberFormatException nfe) {
            throw new TestingUtilsException("port is in valid format to convert to int:" + propVal, nfe);
        }
        return retVal;
    }

    public int getPortAsInt(Properties testingProperties) throws TestingUtilsException {
        return this.getPropertyValueAsInt(testingProperties, IRODS_PORT_KEY);
    }

    public Properties getTestProperties() throws TestingUtilsException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream in = loader.getResourceAsStream("testing.properties");
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException ioe) {
            throw new TestingUtilsException("error loading test properties", ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return properties;
    }

    public URI buildUriFromTestPropertiesForFileInUserDir(Properties testingProperties, String fileName) throws URISyntaxException {
        StringBuilder irodsUri = new StringBuilder();
        irodsUri.append("irods://");
        irodsUri.append(testingProperties.getProperty(IRODS_USER_KEY));
        irodsUri.append(".");
        irodsUri.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        irodsUri.append(":");
        irodsUri.append(testingProperties.getProperty(IRODS_PASSWORD_KEY));
        irodsUri.append("@");
        irodsUri.append(testingProperties.getProperty(IRODS_HOST_KEY));
        irodsUri.append(":");
        irodsUri.append(String.valueOf(testingProperties.getProperty(IRODS_PORT_KEY)));
        irodsUri.append("/");
        irodsUri.append(testingProperties.get(IRODS_ZONE_KEY));
        irodsUri.append("/home/");
        irodsUri.append(testingProperties.get(IRODS_USER_KEY));
        irodsUri.append("/");
        irodsUri.append(testingProperties.getProperty(IRODS_SCRATCH_DIR_KEY));
        irodsUri.append("/");
        irodsUri.append(fileName);
        return new URI(irodsUri.toString());
    }

    public URI buildUriFromTestPropertiesForFileInUserDirNoPasswordOrZone(Properties testingProperties, String fileName) throws URISyntaxException {
        StringBuilder irodsUri = new StringBuilder();
        irodsUri.append("irods://");
        irodsUri.append(testingProperties.getProperty(IRODS_USER_KEY));
        irodsUri.append("@");
        irodsUri.append(testingProperties.getProperty(IRODS_HOST_KEY));
        irodsUri.append(":");
        irodsUri.append(String.valueOf(testingProperties.getProperty(IRODS_PORT_KEY)));
        irodsUri.append("/");
        irodsUri.append(testingProperties.get(IRODS_ZONE_KEY));
        irodsUri.append("/home/");
        irodsUri.append(testingProperties.get(IRODS_USER_KEY));
        irodsUri.append("/");
        irodsUri.append(testingProperties.getProperty(IRODS_SCRATCH_DIR_KEY));
        irodsUri.append("/");
        irodsUri.append(fileName);
        return new URI(irodsUri.toString());
    }

    public URI buildUriFromTestPropertiesForFileNoUserInfo(Properties testingProperties, String fileName) throws URISyntaxException {
        StringBuilder irodsUri = new StringBuilder();
        irodsUri.append("irods://");
        irodsUri.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        irodsUri.append("@");
        irodsUri.append(testingProperties.getProperty(IRODS_HOST_KEY));
        irodsUri.append(":");
        irodsUri.append(String.valueOf(testingProperties.getProperty(IRODS_PORT_KEY)));
        irodsUri.append("/");
        irodsUri.append(testingProperties.get(IRODS_ZONE_KEY));
        irodsUri.append("/home/");
        irodsUri.append(testingProperties.get(IRODS_USER_KEY));
        irodsUri.append("/");
        irodsUri.append(testingProperties.getProperty(IRODS_SCRATCH_DIR_KEY));
        irodsUri.append("/");
        irodsUri.append(fileName);
        return new URI(irodsUri.toString());
    }

    public URI buildUriFromTestPropertiesForFileInLocalScratchDir(Properties testingProperties, String fileName) throws URISyntaxException {
        StringBuilder irodsUri = new StringBuilder();
        irodsUri.append("file://");
        File scratchDir = new File(testingProperties.getProperty(GENERATED_FILE_DIRECTORY_KEY) + fileName);
        scratchDir.mkdirs();
        irodsUri.append(scratchDir.getAbsolutePath());
        return new URI(irodsUri.toString());
    }

    public URI buildUriFromTestPropertiesForFileInSecondaryUserDir(Properties testingProperties, String fileName) throws URISyntaxException {
        StringBuilder irodsUri = new StringBuilder();
        irodsUri.append("irods://");
        irodsUri.append(testingProperties.getProperty(IRODS_SECONDARY_USER_KEY));
        irodsUri.append(".");
        irodsUri.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        irodsUri.append(":");
        irodsUri.append(testingProperties.getProperty(IRODS_SECONDARY_PASSWORD_KEY));
        irodsUri.append("@");
        irodsUri.append(testingProperties.getProperty(IRODS_HOST_KEY));
        irodsUri.append(":");
        irodsUri.append(String.valueOf(testingProperties.getProperty(IRODS_PORT_KEY)));
        irodsUri.append("/");
        irodsUri.append(testingProperties.get(IRODS_ZONE_KEY));
        irodsUri.append("/home/");
        irodsUri.append(testingProperties.get(IRODS_SECONDARY_USER_KEY));
        irodsUri.append("/");
        irodsUri.append(testingProperties.getProperty(IRODS_SCRATCH_DIR_KEY));
        irodsUri.append("/");
        irodsUri.append(fileName);
        return new URI(irodsUri.toString());
    }

    public IRODSAccount buildIRODSAdminAccountFromTestProperties(Properties testingProperties) {
        StringBuilder homeBuilder = new StringBuilder();
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        homeBuilder.append('/');
        homeBuilder.append("home");
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_ADMIN_USER_KEY));
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), testingProperties.getProperty(IRODS_ADMIN_USER_KEY), testingProperties.getProperty(IRODS_ADMIN_PASSWORD_KEY), homeBuilder.toString(), testingProperties.getProperty(IRODS_ZONE_KEY), testingProperties.getProperty(IRODS_RESOURCE_KEY));
        return account;
    }

    public IRODSAccount buildIRODSAccountFromTestPropertiesForRemoteResource(Properties testingProperties) {
        StringBuilder homeBuilder = new StringBuilder();
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        homeBuilder.append('/');
        homeBuilder.append("home");
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_USER_KEY));
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_RESOURCE_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), testingProperties.getProperty(IRODS_USER_KEY), testingProperties.getProperty(IRODS_PASSWORD_KEY), homeBuilder.toString(), testingProperties.getProperty(IRODS_ZONE_KEY), testingProperties.getProperty(IRODS_TERTIARY_RESOURCE_KEY));
        return account;
    }

    public IRODSAccount buildIRODSAccountFromTestProperties(Properties testingProperties) {
        StringBuilder homeBuilder = new StringBuilder();
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        homeBuilder.append('/');
        homeBuilder.append("home");
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_USER_KEY));
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), testingProperties.getProperty(IRODS_USER_KEY), testingProperties.getProperty(IRODS_PASSWORD_KEY), homeBuilder.toString(), testingProperties.getProperty(IRODS_ZONE_KEY), testingProperties.getProperty(IRODS_RESOURCE_KEY));
        return account;
    }

    public IRODSAccount buildAnonymousIRODSAccountFromTestProperties(Properties testingProperties) throws JargonException {
        IRODSAccount account = IRODSAccount.instanceForAnonymous(testingProperties.getProperty(IRODS_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), "", testingProperties.getProperty(IRODS_ZONE_KEY), testingProperties.getProperty(IRODS_RESOURCE_KEY));
        return account;
    }

    public IRODSAccount buildPamIrodsAccountFromTestProperties(Properties testingProperties) throws JargonException {
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), testingProperties.getProperty(IRODS_PAM_USER_KEY), testingProperties.getProperty(IRODS_PAM_PASSWORD_KEY), "", testingProperties.getProperty(IRODS_ZONE_KEY), testingProperties.getProperty(IRODS_RESOURCE_KEY));
        account.setAuthenticationScheme(AuthScheme.PAM);
        return account;
    }

    public IRODSAccount buildIRODSAccountForFederatedZoneFromTestProperties(Properties testingProperties) {
        StringBuilder homeBuilder = new StringBuilder();
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_FEDERATED_ZONE_KEY));
        homeBuilder.append('/');
        homeBuilder.append("home");
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_FEDERATED_USER_KEY));
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_FEDERATED_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_FEDERATED_PORT_KEY)), testingProperties.getProperty(IRODS_FEDERATED_USER_KEY), testingProperties.getProperty(IRODS_FEDERATED_PASSWORD_KEY), homeBuilder.toString(), testingProperties.getProperty(IRODS_FEDERATED_ZONE_KEY), testingProperties.getProperty(IRODS_FEDERATED_RESOURCE_KEY));
        return account;
    }

    public IRODSAccount buildIRODSAccountFromTestPropertiesWithBlankResource(Properties testingProperties) {
        StringBuilder homeBuilder = new StringBuilder();
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        homeBuilder.append('/');
        homeBuilder.append("home");
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_USER_KEY));
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), testingProperties.getProperty(IRODS_USER_KEY), testingProperties.getProperty(IRODS_PASSWORD_KEY), homeBuilder.toString(), testingProperties.getProperty(IRODS_ZONE_KEY), "");
        return account;
    }

    public IRODSAccount buildIRODSAccountForIRODSUserFromTestPropertiesForGivenUser(Properties testingProperties, String userName, String password) {
        StringBuilder homeBuilder = new StringBuilder();
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        homeBuilder.append('/');
        homeBuilder.append("home");
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_USER_KEY));
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), userName, password, homeBuilder.toString(), testingProperties.getProperty(IRODS_ZONE_KEY), testingProperties.getProperty(IRODS_RESOURCE_KEY));
        return account;
    }

    public IRODSAccount buildIRODSAccountFromSecondaryTestProperties(Properties testingProperties) {
        StringBuilder homeBuilder = new StringBuilder();
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        homeBuilder.append('/');
        homeBuilder.append("home");
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_SECONDARY_USER_KEY));
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), testingProperties.getProperty(IRODS_SECONDARY_USER_KEY), testingProperties.getProperty(IRODS_SECONDARY_PASSWORD_KEY), homeBuilder.toString(), testingProperties.getProperty(IRODS_ZONE_KEY), testingProperties.getProperty(IRODS_SECONDARY_RESOURCE_KEY));
        return account;
    }

    public IRODSAccount buildIRODSAccountFromTertiaryTestProperties(Properties testingProperties) {
        StringBuilder homeBuilder = new StringBuilder();
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_ZONE_KEY));
        homeBuilder.append('/');
        homeBuilder.append("home");
        homeBuilder.append('/');
        homeBuilder.append(testingProperties.getProperty(IRODS_TERTIARY_USER_KEY));
        IRODSAccount account = new IRODSAccount(testingProperties.getProperty(IRODS_HOST_KEY), Integer.parseInt(testingProperties.getProperty(IRODS_PORT_KEY)), testingProperties.getProperty(IRODS_TERTIARY_USER_KEY), testingProperties.getProperty(IRODS_TERTIARY_PASSWORD_KEY), homeBuilder.toString(), testingProperties.getProperty(IRODS_ZONE_KEY), testingProperties.getProperty(IRODS_TERTIARY_RESOURCE_KEY));
        return account;
    }

    public String buildIRODSCollectionAbsolutePathFromTestProperties(Properties testingProperties, String collectionPathBelowScratch) throws TestingUtilsException {
        if (testingProperties.get(IRODS_SCRATCH_DIR_KEY) == null) {
            throw new TestingUtilsException("scratch path not provided in testing.properties");
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_ZONE_KEY));
        pathBuilder.append("/home/");
        pathBuilder.append(testingProperties.get(IRODS_USER_KEY));
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_SCRATCH_DIR_KEY));
        pathBuilder.append('/');
        pathBuilder.append(collectionPathBelowScratch);
        return pathBuilder.toString();
    }

    public String buildIRODSCollectionAbsolutePathFromTestPropertiesForRods(Properties testingProperties, String collectionPathBelowScratch) throws TestingUtilsException {
        if (testingProperties.get(IRODS_SCRATCH_DIR_KEY) == null) {
            throw new TestingUtilsException("scratch path not provided in testing.properties");
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_ZONE_KEY));
        pathBuilder.append("/home/");
        pathBuilder.append("rods");
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_SCRATCH_DIR_KEY));
        pathBuilder.append('/');
        pathBuilder.append(collectionPathBelowScratch);
        return pathBuilder.toString();
    }

    public String buildIRODSCollectionAbsolutePathFromFederatedZoneReadTestProperties(Properties testingProperties, String collectionPathBelowScratch) throws TestingUtilsException {
        if (testingProperties.get(IRODS_SCRATCH_DIR_KEY) == null) {
            throw new TestingUtilsException("scratch path not provided in testing.properties");
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_FEDERATED_ZONE_KEY));
        pathBuilder.append("/home/");
        pathBuilder.append(testingProperties.get(IRODS_FEDERATED_USER_KEY));
        pathBuilder.append("/fedread/");
        pathBuilder.append(testingProperties.get(IRODS_SCRATCH_DIR_KEY));
        pathBuilder.append('/');
        pathBuilder.append(collectionPathBelowScratch);
        return pathBuilder.toString();
    }

    public String buildIRODSCollectionAbsolutePathFromFederatedZoneHomeDirTestProperties(Properties testingProperties, String collectionPathBelowScratch) throws TestingUtilsException {
        if (testingProperties.get(IRODS_SCRATCH_DIR_KEY) == null) {
            throw new TestingUtilsException("scratch path not provided in testing.properties");
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_FEDERATED_ZONE_KEY));
        pathBuilder.append("/home/");
        pathBuilder.append(testingProperties.get(IRODS_USER_KEY));
        pathBuilder.append("#");
        pathBuilder.append(testingProperties.get(IRODS_ZONE_KEY));
        pathBuilder.append('/');
        pathBuilder.append(collectionPathBelowScratch);
        return pathBuilder.toString();
    }

    public String buildIRODSCollectionAbsolutePathFromSecondaryTestProperties(Properties testingProperties, String collectionPathBelowScratch) throws TestingUtilsException {
        if (testingProperties.get(IRODS_SCRATCH_DIR_KEY) == null) {
            throw new TestingUtilsException("scratch path not provided in testing.properties");
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_ZONE_KEY));
        pathBuilder.append("/home/");
        pathBuilder.append(testingProperties.get(IRODS_SECONDARY_USER_KEY));
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_SCRATCH_DIR_KEY));
        pathBuilder.append('/');
        pathBuilder.append(collectionPathBelowScratch);
        return pathBuilder.toString();
    }

    public String buildIRODSCollectionAbsolutePathFromPamTestProperties(Properties testingProperties, String collectionPathBelowScratch) throws TestingUtilsException {
        if (testingProperties.get(IRODS_SCRATCH_DIR_KEY) == null) {
            throw new TestingUtilsException("scratch path not provided in testing.properties");
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_ZONE_KEY));
        pathBuilder.append("/home/");
        pathBuilder.append(testingProperties.get(IRODS_PAM_USER_KEY));
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_SCRATCH_DIR_KEY));
        pathBuilder.append('/');
        pathBuilder.append(collectionPathBelowScratch);
        return pathBuilder.toString();
    }

    public String buildIRODSCollectionRelativePathFromTestProperties(Properties testingProperties, String collectionPathBelowScratch) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(testingProperties.get(IRODS_SCRATCH_DIR_KEY));
        pathBuilder.append('/');
        pathBuilder.append(collectionPathBelowScratch);
        return pathBuilder.toString();
    }

    public boolean isTestDistributedResources(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.distributed.resources");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean getPropertyValueAsBoolean(Properties testingProperties, String key) {
        String val = (String)testingProperties.get(key);
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestKerberos(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.kerberos");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestWorkflow(Properties testingProperties) {
        String val = (String)testingProperties.get(IRODS_TEST_OPTION_EXERCISE_WORKFLOW);
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestFileSystemMount(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.exercise.filesystem.mount");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestFileSystemMountLocal(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.exercise.filesystem.mount.local");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestRegistration(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.registration");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestRemoteExecStream(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.exercise.remoteexecstream");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestAudit(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.exercise.audit");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestTickets(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.exercise.ticket");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestGSI(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.gsi");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestPAM(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.pam");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestSsl(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.ssl.configured");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestFederatedZone(Properties testingProperties) {
        String val = (String)testingProperties.get(IRODS_TEST_FEDERATED_ZONE_KEY);
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestStrictACL(Properties testingProperties) {
        String val = (String)testingProperties.get("test.option.strictACL");
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isTestEirods(Properties testingProperties) {
        String val = (String)testingProperties.get(IRODS_TEST_OPTION_EIRODS);
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public String buildIRODSCollectionAbsolutePathFromFederatedZoneWriteTestProperties(Properties testingProperties, String collectionPathBelowScratch) throws TestingUtilsException {
        if (testingProperties.get(IRODS_SCRATCH_DIR_KEY) == null) {
            throw new TestingUtilsException("scratch path not provided in testing.properties");
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append('/');
        pathBuilder.append(testingProperties.get(IRODS_FEDERATED_ZONE_KEY));
        pathBuilder.append("/home/");
        pathBuilder.append(testingProperties.get(IRODS_FEDERATED_USER_KEY));
        pathBuilder.append("/fedwrite/");
        pathBuilder.append(testingProperties.get(IRODS_SCRATCH_DIR_KEY));
        pathBuilder.append('/');
        pathBuilder.append(collectionPathBelowScratch);
        return pathBuilder.toString();
    }

    public static IRODSAccount buildBogusIrodsAccount() throws JargonException {
        return IRODSAccount.instance("host", 1247, "userName", "password", "", "zone", "");
    }
}

