/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.protovalues;

public enum EncryptionAlgorithmEnum {
    AES_256_CBC("AES-256-CBC", "AES/CBC/PKCS5Padding", "PBKDF2WithHmacSha1", 256);

    private String textValue;
    private String cypherKey;
    private String keyGenType;
    private int keySize;

    private EncryptionAlgorithmEnum(String textValue, String cypherKey, String keyGenType, int keySize) {
        this.textValue = textValue;
        this.cypherKey = cypherKey;
        this.keyGenType = keyGenType;
        this.keySize = keySize;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public static EncryptionAlgorithmEnum findTypeByString(String userType) {
        EncryptionAlgorithmEnum checksumEncodingValue = null;
        for (EncryptionAlgorithmEnum checksumEnumValue : EncryptionAlgorithmEnum.values()) {
            if (!checksumEnumValue.getTextValue().equals(userType)) continue;
            checksumEncodingValue = checksumEnumValue;
            break;
        }
        if (checksumEncodingValue == null) {
            checksumEncodingValue = AES_256_CBC;
        }
        return checksumEncodingValue;
    }

    public String getCypherKey() {
        return this.cypherKey;
    }

    public String getKeyGenType() {
        return this.keyGenType;
    }

    public synchronized int getKeySize() {
        return this.keySize;
    }
}

