/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.log4j;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import org.perf4j.GroupedTimingStatistics;
import org.perf4j.StopWatch;
import org.perf4j.helpers.GroupingStatisticsIterator;
import org.perf4j.helpers.StopWatchParser;

public class AsyncCoalescingStatisticsAppender
extends AppenderSkeleton
implements AppenderAttachable {
    private long timeSlice = 30000L;
    private Level downstreamLogLevel = Level.INFO;
    private boolean createRollupStatistics = false;
    private int queueSize = 1024;
    private final AppenderAttachableImpl downstreamAppenders = new AppenderAttachableImpl();
    private BlockingQueue<String> loggedMessages = null;
    private Thread drainingThread = null;
    private volatile int numDiscardedMessages = 0;

    public long getTimeSlice() {
        return this.timeSlice;
    }

    public void setTimeSlice(long timeSlice) {
        this.timeSlice = timeSlice;
    }

    public String getDownstreamLogLevel() {
        return this.downstreamLogLevel.toString();
    }

    public void setDownstreamLogLevel(String downstreamLogLevel) {
        this.downstreamLogLevel = Level.toLevel((String)downstreamLogLevel);
    }

    public boolean isCreateRollupStatistics() {
        return this.createRollupStatistics;
    }

    public void setCreateRollupStatistics(boolean createRollupStatistics) {
        this.createRollupStatistics = createRollupStatistics;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public synchronized void activateOptions() {
        if (this.drainingThread != null) {
            this.stopDrainingThread();
        }
        this.numDiscardedMessages = 0;
        this.loggedMessages = new ArrayBlockingQueue<String>(this.getQueueSize());
        this.drainingThread = new Thread((Runnable)new Dispatcher(), "perf4j-async-stats-appender-sink-" + this.getName());
        this.drainingThread.setDaemon(true);
        this.drainingThread.start();
    }

    public int getNumDiscardedMessages() {
        return this.numDiscardedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.addAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.getAppender(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.isAttached(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAppender(name);
        }
    }

    protected void append(LoggingEvent event) {
        String message = String.valueOf(event.getMessage());
        if (message.startsWith("start")) {
            this.pushMessageOntoQueue(message);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stopDrainingThread();
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            Enumeration enumer = this.downstreamAppenders.getAllAppenders();
            while (enumer != null && enumer.hasMoreElements()) {
                ((Appender)enumer.nextElement()).close();
            }
        }
    }

    private void pushMessageOntoQueue(String message) {
        if (!this.loggedMessages.offer(message)) {
            ++this.numDiscardedMessages;
            this.getErrorHandler().error(message);
        }
    }

    private void stopDrainingThread() {
        try {
            this.loggedMessages.put("");
            this.drainingThread.join(10000L);
        }
        catch (Exception e) {
            LogLog.warn((String)"Unexpected error stopping AsyncCoalescingStatisticsAppender draining thread", (Throwable)e);
        }
    }

    protected StopWatchParser newStopWatchParser() {
        return new StopWatchParser();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StopWatchesFromQueueIterator
    implements Iterator<StopWatch> {
        private LinkedList<String> drainedMessages = new LinkedList();
        private StopWatchParser stopWatchParser = AsyncCoalescingStatisticsAppender.this.newStopWatchParser();
        private StopWatch nextStopWatch;
        private boolean done;

        private StopWatchesFromQueueIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextStopWatch == null) {
                this.nextStopWatch = this.getNext();
            }
            return this.nextStopWatch != null;
        }

        @Override
        public StopWatch next() {
            if (this.nextStopWatch == null) {
                this.nextStopWatch = this.getNext();
                if (this.nextStopWatch == null) {
                    throw new NoSuchElementException();
                }
            }
            StopWatch retVal = this.nextStopWatch;
            this.nextStopWatch = null;
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private StopWatch getNext() {
            StopWatch parsedStopWatch;
            if (this.done) {
                return null;
            }
            block2: while (true) {
                String message;
                if (this.drainedMessages.isEmpty()) {
                    AsyncCoalescingStatisticsAppender.this.loggedMessages.drainTo(this.drainedMessages, 64);
                    if (this.drainedMessages.isEmpty()) {
                        try {
                            this.drainedMessages.add((String)AsyncCoalescingStatisticsAppender.this.loggedMessages.take());
                        }
                        catch (InterruptedException ie) {
                            this.done = true;
                            return null;
                        }
                    }
                }
                do {
                    if (this.drainedMessages.isEmpty()) continue block2;
                    message = this.drainedMessages.removeFirst();
                    if (message.length() != 0) continue;
                    this.done = true;
                    return null;
                } while ((parsedStopWatch = this.stopWatchParser.parseStopWatch(message)) == null);
                break;
            }
            return parsedStopWatch;
        }
    }

    private class Dispatcher
    implements Runnable {
        private Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GroupingStatisticsIterator statsIterator = new GroupingStatisticsIterator(new StopWatchesFromQueueIterator(), AsyncCoalescingStatisticsAppender.this.timeSlice, AsyncCoalescingStatisticsAppender.this.createRollupStatistics);
            while (statsIterator.hasNext()) {
                GroupedTimingStatistics stats = statsIterator.next();
                LoggingEvent coalescedLoggingEvent = new LoggingEvent(Logger.class.getName(), (Category)Logger.getLogger((String)"org.perf4j.TimingLogger"), System.currentTimeMillis(), (Priority)AsyncCoalescingStatisticsAppender.this.downstreamLogLevel, (Object)stats, null);
                try {
                    AppenderAttachableImpl appenderAttachableImpl = AsyncCoalescingStatisticsAppender.this.downstreamAppenders;
                    synchronized (appenderAttachableImpl) {
                        AsyncCoalescingStatisticsAppender.this.downstreamAppenders.appendLoopOnAppenders(coalescedLoggingEvent);
                    }
                }
                catch (Exception e) {
                    AsyncCoalescingStatisticsAppender.this.getErrorHandler().error("Exception calling append with GroupedTimingStatistics on downstream appender", e, -1, coalescedLoggingEvent);
                }
            }
        }
    }
}

