/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.auth;

import ch.cyberduck.core.AuthenticationProvider;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.threading.CancelCallback;
import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyV1KeyFile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS5KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PuTTYKeyFile;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SFTPPublicKeyAuthentication
implements AuthenticationProvider<Boolean> {
    private static final Logger log = Logger.getLogger(SFTPPublicKeyAuthentication.class);
    private final SFTPSession session;

    public SFTPPublicKeyAuthentication(SFTPSession session) {
        this.session = session;
    }

    public Boolean authenticate(final Host bookmark, final LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        final Credentials credentials = bookmark.getCredentials();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Login using public key authentication with credentials %s", credentials));
        }
        if (credentials.isPublicKeyAuthentication()) {
            final Local identity = credentials.getIdentity();
            final AtomicBoolean canceled = new AtomicBoolean();
            try {
                FileKeyProvider provider;
                KeyFormat format = KeyProviderUtil.detectKeyFileFormat((Reader)new InputStreamReader(identity.getInputStream(), Charset.forName("UTF-8")), (boolean)true);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Reading private key %s with key format %s", identity, format));
                }
                switch (format) {
                    case PKCS5: {
                        provider = new PKCS5KeyFile.Factory().create();
                        break;
                    }
                    case PKCS8: {
                        provider = new PKCS8KeyFile.Factory().create();
                        break;
                    }
                    case OpenSSH: {
                        provider = new OpenSSHKeyFile.Factory().create();
                        break;
                    }
                    case OpenSSHv1: {
                        provider = new OpenSSHKeyV1KeyFile.Factory().create();
                        break;
                    }
                    case PuTTY: {
                        provider = new PuTTYKeyFile.Factory().create();
                        break;
                    }
                    default: {
                        throw new InteroperabilityException(String.format("Unknown key format for file %s", identity.getName()));
                    }
                }
                provider.init((Reader)new InputStreamReader(identity.getInputStream(), Charset.forName("UTF-8")), new PasswordFinder(){

                    public char[] reqPassword(Resource<?> resource) {
                        if (StringUtils.isEmpty((CharSequence)credentials.getIdentityPassphrase())) {
                            try {
                                Credentials input = prompt.prompt(bookmark, LocaleFactory.localizedString((String)"Private key password protected", (String)"Credentials"), String.format("%s (%s)", LocaleFactory.localizedString((String)"Enter the passphrase for the private key file", (String)"Credentials"), identity.getAbbreviatedPath()), new LoginOptions().icon(bookmark.getProtocol().disk()).user(false).password(true));
                                credentials.setSaved(input.isSaved());
                                credentials.setIdentityPassphrase(input.getPassword());
                            }
                            catch (LoginCanceledException e) {
                                canceled.set(true);
                                return "".toCharArray();
                            }
                        }
                        return credentials.getIdentityPassphrase().toCharArray();
                    }

                    public boolean shouldRetry(Resource<?> resource) {
                        return false;
                    }
                });
                ((SSHClient)this.session.getClient()).auth(credentials.getUsername(), new AuthMethod[]{new AuthPublickey((KeyProvider)provider)});
                return ((SSHClient)this.session.getClient()).isAuthenticated();
            }
            catch (IOException e) {
                if (canceled.get()) {
                    throw new LoginCanceledException();
                }
                throw new SFTPExceptionMappingService().map(e);
            }
        }
        return false;
    }

    public String getMethod() {
        return "publickey";
    }
}

