/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.onedrive.features.OneDriveHomeFinderFeature;
import java.io.IOException;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;

public class OneDriveQuotaFeature
implements Quota {
    private final OneDriveSession session;

    public OneDriveQuotaFeature(OneDriveSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        OneDriveDrive.Metadata metadata;
        Path home = new OneDriveHomeFinderFeature(this.session).find();
        try {
            metadata = new OneDriveDrive((OneDriveAPI)this.session.getClient(), home.getName()).getMetadata(new OneDriveExpand[0]);
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Failure to read attributes of {0}", e, home);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, home);
        }
        return new Quota.Space(Long.valueOf(metadata.getUsed() != null ? metadata.getUsed() : 0L), Long.valueOf(metadata.getTotal() != null ? metadata.getTotal() : Long.MAX_VALUE));
    }
}

