/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.http.DelayedHttpEntity;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.threading.DefaultThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.io.input.NullInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;

public abstract class OneDriveCommonsHttpRequestExecutor
implements RequestExecutor {
    private final CloseableHttpClient client;

    public OneDriveCommonsHttpRequestExecutor(CloseableHttpClient client) {
        this.client = client;
    }

    public RequestExecutor.Upload doPost(URL url, Set<RequestHeader> headers) throws IOException {
        HttpPost request = new HttpPost(url.toString());
        return this.doUpload(url, headers, (HttpEntityEnclosingRequestBase)request);
    }

    public RequestExecutor.Upload doPut(URL url, Set<RequestHeader> headers) throws IOException {
        HttpPut request = new HttpPut(url.toString());
        return this.doUpload(url, headers, (HttpEntityEnclosingRequestBase)request);
    }

    public RequestExecutor.Upload doPatch(URL url, Set<RequestHeader> headers) throws IOException {
        HttpPatch request = new HttpPatch(url.toString());
        return this.doUpload(url, headers, (HttpEntityEnclosingRequestBase)request);
    }

    protected RequestExecutor.Upload doUpload(URL url, final Set<RequestHeader> headers, final HttpEntityEnclosingRequestBase request) {
        for (RequestHeader header : headers) {
            if (header.getKey().equals("Transfer-Encoding") || header.getKey().equals("Content-Length")) continue;
            request.addHeader((Header)new BasicHeader(header.getKey(), header.getValue()));
        }
        final CountDownLatch entry = new CountDownLatch(1);
        final DelayedHttpEntity entity = new DelayedHttpEntity(entry){

            public long getContentLength() {
                for (RequestHeader header : headers) {
                    if (!header.getKey().equals("Content-Length")) continue;
                    return Long.valueOf(header.getValue());
                }
                return -1L;
            }
        };
        request.setEntity((HttpEntity)entity);
        final DefaultThreadPool executor = new DefaultThreadPool(String.format("http-%s", url), 1);
        final Future future = executor.execute((Callable)new Callable<CloseableHttpResponse>(){

            @Override
            public CloseableHttpResponse call() throws Exception {
                return OneDriveCommonsHttpRequestExecutor.this.client.execute((HttpUriRequest)request);
            }
        });
        return new RequestExecutor.Upload(){

            public RequestExecutor.Response getResponse() throws IOException {
                CloseableHttpResponse response;
                try {
                    response = (CloseableHttpResponse)future.get();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                catch (ExecutionException e) {
                    throw new IOException(e.getCause());
                }
                finally {
                    executor.shutdown(false);
                }
                return new CommonsHttpResponse((HttpResponse)response);
            }

            public OutputStream getOutputStream() {
                try {
                    entry.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return entity.getStream();
            }
        };
    }

    public RequestExecutor.Response doGet(URL url, Set<RequestHeader> headers) throws IOException {
        HttpGet request = new HttpGet(url.toString());
        for (RequestHeader header : headers) {
            if (header.getKey().equals("Transfer-Encoding") || header.getKey().equals("Content-Length")) continue;
            request.addHeader((Header)new BasicHeader(header.getKey(), header.getValue()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        return new CommonsHttpResponse((HttpResponse)response);
    }

    public RequestExecutor.Response doDelete(URL url, Set<RequestHeader> headers) throws IOException {
        HttpDelete request = new HttpDelete(url.toString());
        for (RequestHeader header : headers) {
            if (header.getKey().equals("Transfer-Encoding") || header.getKey().equals("Content-Length")) continue;
            request.addHeader((Header)new BasicHeader(header.getKey(), header.getValue()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        return new CommonsHttpResponse((HttpResponse)response);
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void close() throws IOException {
        this.client.close();
    }

    private final class CommonsHttpResponse
    extends RequestExecutor.Response {
        private HttpResponse response;

        public CommonsHttpResponse(HttpResponse response) throws IOException {
            super((InputStream)(null == response.getEntity() ? new NullInputStream(0L) : new HttpMethodReleaseInputStream(response)));
            this.response = response;
        }

        public int getStatusCode() throws IOException {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getStatusMessage() throws IOException {
            return this.response.getStatusLine().getReasonPhrase();
        }

        public String getLocation() {
            Header locationHeader = this.response.getFirstHeader("Location");
            if (null == locationHeader) {
                return null;
            }
            return locationHeader.getValue();
        }
    }
}

