/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import java.io.IOException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class SFTPExceptionMappingService
extends AbstractExceptionMappingService<IOException> {
    private static final Logger log = Logger.getLogger(SFTPExceptionMappingService.class);

    public BackgroundException map(IOException e) {
        SFTPException failure;
        if (ExceptionUtils.getRootCause((Throwable)e) instanceof SSHException) {
            return this.map((IOException)((SSHException)ExceptionUtils.getRootCause((Throwable)e)));
        }
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, e.getMessage());
        if (ExceptionUtils.getRootCause((Throwable)e) != null && !StringUtils.equals((CharSequence)e.getMessage(), (CharSequence)ExceptionUtils.getRootCause((Throwable)e).getMessage())) {
            this.append(buffer, ExceptionUtils.getRootCause((Throwable)e).getMessage());
        }
        if (e instanceof SFTPException) {
            failure = (SFTPException)e;
            Response.StatusCode code = failure.getStatusCode();
            switch (code) {
                case UNKNOWN: 
                case BAD_MESSAGE: 
                case FAILURE: 
                case OP_UNSUPPORTED: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)e);
                }
                case NO_SUCH_FILE: {
                    return new NotfoundException(buffer.toString(), (Throwable)e);
                }
                case PERMISSION_DENIED: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)e);
                }
                case NO_CONNECTION: 
                case CONNECITON_LOST: {
                    return new ConnectionRefusedException(buffer.toString(), (Throwable)e);
                }
            }
        }
        if (e instanceof UserAuthException) {
            return new LoginFailureException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof ConnectionException) {
            return new ConnectionRefusedException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof Buffer.BufferException) {
            return new InteroperabilityException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof SSHException) {
            failure = (SSHException)e;
            DisconnectReason reason = failure.getDisconnectReason();
            return this.map(e, buffer, reason);
        }
        return this.wrap(e, buffer);
    }

    public BackgroundException map(IOException e, StringBuilder buffer, DisconnectReason reason) {
        String failure = buffer.toString();
        if (DisconnectReason.HOST_KEY_NOT_VERIFIABLE.equals((Object)reason)) {
            log.warn((Object)String.format("Failure verifying host key. %s", failure));
            return new ConnectionCanceledException((Throwable)e);
        }
        if (DisconnectReason.PROTOCOL_ERROR.equals((Object)reason)) {
            return new InteroperabilityException(failure, (Throwable)e);
        }
        if (DisconnectReason.ILLEGAL_USER_NAME.equals((Object)reason)) {
            return new LoginFailureException(failure, (Throwable)e);
        }
        if (DisconnectReason.NO_MORE_AUTH_METHODS_AVAILABLE.equals((Object)reason)) {
            return new LoginFailureException(failure, (Throwable)e);
        }
        if (DisconnectReason.PROTOCOL_VERSION_NOT_SUPPORTED.equals((Object)reason)) {
            return new InteroperabilityException(failure, (Throwable)e);
        }
        if (e instanceof TransportException) {
            return new ConnectionRefusedException(buffer.toString(), (Throwable)e);
        }
        return this.wrap(e, buffer);
    }
}

