/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import java.io.IOException;
import net.schmizz.sshj.sftp.FileAttributes;

public class SFTPAttributesFinderFeature
implements AttributesFinder {
    private final SFTPSession session;

    public SFTPAttributesFinderFeature(SFTPSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            FileAttributes stat = file.isSymbolicLink() ? this.session.sftp().lstat(file.getAbsolute()) : this.session.sftp().stat(file.getAbsolute());
            switch (stat.getType()) {
                case BLOCK_SPECIAL: 
                case CHAR_SPECIAL: 
                case FIFO_SPECIAL: 
                case SOCKET_SPECIAL: 
                case REGULAR: 
                case SYMLINK: {
                    if (file.getType().contains(AbstractPath.Type.file)) break;
                    throw new NotfoundException(String.format("Path %s is file", file.getAbsolute()));
                }
                case DIRECTORY: {
                    if (file.getType().contains(AbstractPath.Type.directory)) break;
                    throw new NotfoundException(String.format("Path %s is directory", file.getAbsolute()));
                }
            }
            return this.toAttributes(stat);
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        return this;
    }

    public PathAttributes toAttributes(FileAttributes stat) {
        PathAttributes attributes = new PathAttributes();
        switch (stat.getType()) {
            case REGULAR: 
            case UNKNOWN: {
                attributes.setSize(stat.getSize());
            }
        }
        if (0 != stat.getMode().getPermissionsMask()) {
            attributes.setPermission(new Permission(Integer.toString(stat.getMode().getPermissionsMask(), 8)));
        }
        if (0 != stat.getUID()) {
            attributes.setOwner(String.valueOf(stat.getUID()));
        }
        if (0 != stat.getGID()) {
            attributes.setGroup(String.valueOf(stat.getGID()));
        }
        if (0L != stat.getMtime()) {
            attributes.setModificationDate(stat.getMtime() * 1000L);
        }
        if (0L != stat.getAtime()) {
            attributes.setAccessedDate(stat.getAtime() * 1000L);
        }
        return attributes;
    }
}

