/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.AbstractHostKeyCallback;
import java.security.Key;
import java.security.PublicKey;
import net.schmizz.sshj.common.KeyType;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public abstract class PreferencesHostKeyVerifier
extends AbstractHostKeyCallback {
    private static final Logger log = Logger.getLogger(PreferencesHostKeyVerifier.class);
    private final Preferences preferences = PreferencesFactory.get();

    public boolean verify(String hostname, int port, PublicKey key) throws ConnectionCanceledException, ChecksumException {
        String lookup = this.preferences.getProperty(this.getFormat(hostname, key));
        if (StringUtils.equals((CharSequence)Base64.toBase64String((byte[])key.getEncoded()), (CharSequence)lookup)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Accepted host key %s matching %s", key, lookup));
            }
            return true;
        }
        boolean accept = null == lookup ? this.isUnknownKeyAccepted(hostname, key) : this.isChangedKeyAccepted(hostname, key);
        return accept;
    }

    private String getFormat(String hostname, PublicKey key) {
        return String.format("ssh.hostkey.%s.%s", KeyType.fromKey((Key)key), hostname);
    }

    @Override
    protected void allow(String hostname, PublicKey key, boolean persist) {
        if (persist) {
            this.preferences.setProperty(this.getFormat(hostname, key), Base64.toBase64String((byte[])key.getEncoded()));
        }
    }
}

