/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.http.SSLConfig;
import com.dropbox.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;

public class StandardHttpRequestor
extends HttpRequestor {
    private static final Logger LOGGER = Logger.getLogger(StandardHttpRequestor.class.getCanonicalName());
    public static final StandardHttpRequestor INSTANCE = new StandardHttpRequestor(Config.DEFAULT_INSTANCE);
    private static volatile boolean certPinningWarningLogged = false;
    private final Config config;

    public StandardHttpRequestor(Config config) {
        this.config = config;
    }

    private HttpRequestor.Response toResponse(HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        InputStream bodyStream = responseCode >= 400 || responseCode == -1 ? conn.getErrorStream() : conn.getInputStream();
        this.interceptResponse(conn);
        return new HttpRequestor.Response(responseCode, bodyStream, conn.getHeaderFields());
    }

    @Override
    public HttpRequestor.Response doGet(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("GET");
        conn.connect();
        return this.toResponse(conn);
    }

    @Override
    public Uploader startPost(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("POST");
        return new Uploader(conn);
    }

    @Override
    public Uploader startPut(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("PUT");
        return new Uploader(conn);
    }

    @Deprecated
    protected void configureConnection(HttpsURLConnection conn) throws IOException {
    }

    protected void configure(HttpURLConnection conn) throws IOException {
    }

    protected void interceptResponse(HttpURLConnection conn) throws IOException {
    }

    private static OutputStream getOutputStream(HttpURLConnection conn) throws IOException {
        conn.setDoOutput(true);
        return conn.getOutputStream();
    }

    private HttpURLConnection prepRequest(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        URL urlObject = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlObject.openConnection(this.config.getProxy());
        conn.setConnectTimeout((int)this.config.getConnectTimeoutMillis());
        conn.setReadTimeout((int)this.config.getReadTimeoutMillis());
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        if (conn instanceof HttpsURLConnection) {
            SSLConfig.apply((HttpsURLConnection)conn);
            this.configureConnection((HttpsURLConnection)conn);
        } else {
            StandardHttpRequestor.logCertificatePinningWarning();
        }
        this.configure(conn);
        for (HttpRequestor.Header header : headers) {
            conn.addRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static void logCertificatePinningWarning() {
        if (!certPinningWarningLogged) {
            certPinningWarningLogged = true;
            LOGGER.warning("Certificate pinning disabled for HTTPS connections. This is likely because your JRE does not return javax.net.ssl.HttpsURLConnection objects for https network connections. Be aware your app may be prone to man-in-the-middle attacks without proper SSL certificate validation. If you are using Google App Engine, please configure DbxRequestConfig to use GoogleAppEngineRequestor.");
        }
    }

    public static final class Config {
        public static final Config DEFAULT_INSTANCE = Config.builder().build();
        private final Proxy proxy;
        private final long connectTimeoutMillis;
        private final long readTimeoutMillis;

        private Config(Proxy proxy, long connectTimeoutMillis, long readTimeoutMillis) {
            this.proxy = proxy;
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.readTimeoutMillis = readTimeoutMillis;
        }

        public Proxy getProxy() {
            return this.proxy;
        }

        public long getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public long getReadTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public Builder copy() {
            return new Builder(this.proxy, this.connectTimeoutMillis, this.readTimeoutMillis);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Proxy proxy;
            private long connectTimeoutMillis;
            private long readTimeoutMillis;

            private Builder() {
                this(Proxy.NO_PROXY, HttpRequestor.DEFAULT_CONNECT_TIMEOUT_MILLIS, HttpRequestor.DEFAULT_READ_TIMEOUT_MILLIS);
            }

            private Builder(Proxy proxy, long connectTimeoutMillis, long readTimeoutMillis) {
                this.proxy = proxy;
                this.connectTimeoutMillis = connectTimeoutMillis;
                this.readTimeoutMillis = readTimeoutMillis;
            }

            public Builder withProxy(Proxy proxy) {
                if (proxy == null) {
                    throw new NullPointerException("proxy");
                }
                this.proxy = proxy;
                return this;
            }

            public Builder withNoConnectTimeout() {
                return this.withConnectTimeout(0L, TimeUnit.MILLISECONDS);
            }

            public Builder withConnectTimeout(long timeout, TimeUnit unit) {
                this.connectTimeoutMillis = Builder.checkTimeoutMillis(timeout, unit);
                return this;
            }

            public Builder withNoReadTimeout() {
                return this.withReadTimeout(0L, TimeUnit.MILLISECONDS);
            }

            public Builder withReadTimeout(long timeout, TimeUnit unit) {
                this.readTimeoutMillis = Builder.checkTimeoutMillis(timeout, unit);
                return this;
            }

            public Config build() {
                return new Config(this.proxy, this.connectTimeoutMillis, this.readTimeoutMillis);
            }

            private static long checkTimeoutMillis(long timeout, TimeUnit unit) {
                if (unit == null) {
                    throw new NullPointerException("unit");
                }
                if (timeout < 0L) {
                    throw new IllegalArgumentException("timeout must be non-negative");
                }
                long millis = unit.toMillis(timeout);
                if (Integer.MAX_VALUE < millis) {
                    throw new IllegalArgumentException("timeout too large, must be less than: 2147483647");
                }
                return millis;
            }
        }
    }

    private class Uploader
    extends HttpRequestor.Uploader {
        private final OutputStream out;
        private HttpURLConnection conn;

        public Uploader(HttpURLConnection conn) throws IOException {
            this.conn = conn;
            this.out = StandardHttpRequestor.getOutputStream(conn);
            conn.connect();
        }

        @Override
        public OutputStream getBody() {
            return this.out;
        }

        @Override
        public void abort() {
            if (this.conn == null) {
                throw new IllegalStateException("Can't abort().  Uploader already closed.");
            }
            this.conn.disconnect();
            this.conn = null;
        }

        @Override
        public void close() {
            if (this.conn == null) {
                return;
            }
            if (this.conn.getDoOutput()) {
                try {
                    IOUtil.closeQuietly(this.conn.getOutputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.conn = null;
        }

        @Override
        public HttpRequestor.Response finish() throws IOException {
            if (this.conn == null) {
                throw new IllegalStateException("Can't finish().  Uploader already closed.");
            }
            try {
                HttpRequestor.Response response = StandardHttpRequestor.this.toResponse(this.conn);
                return response;
            }
            finally {
                this.conn = null;
            }
        }
    }
}

