/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.exception;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.joyent.manta.client.MantaObjectMapper;
import com.joyent.manta.domain.ErrorDetail;
import com.joyent.manta.exception.MantaErrorCode;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaHttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaClientHttpResponseException
extends MantaIOException {
    private static final long serialVersionUID = 5696045042485801788L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaClientHttpResponseException.class);
    private MantaErrorCode serverCode;
    private String requestId;
    private StatusLine statusLine;
    private MantaHttpHeaders headers;
    private String content;

    public MantaClientHttpResponseException() {
    }

    public MantaClientHttpResponseException(String message) {
        super(message);
    }

    public MantaClientHttpResponseException(String message, Throwable cause) {
        super(message, cause);
    }

    public MantaClientHttpResponseException(Throwable cause) {
        super(cause);
    }

    public MantaClientHttpResponseException(HttpRequest request, HttpResponse response, String path) {
        this(request, response, path, (int[])null);
    }

    public MantaClientHttpResponseException(HttpRequest request, HttpResponse response, String path, int ... expectedResponseCodes) {
        super(MantaClientHttpResponseException.buildExceptionMessageFromHttpExchange(request, response, path, expectedResponseCodes));
        HttpEntity entity = response.getEntity();
        ContentType jsonContentType = ContentType.APPLICATION_JSON;
        ContentType responseContentType = entity != null && entity.getContentType() != null ? ContentType.getLenient((HttpEntity)entity) : null;
        ErrorDetail errorDetail = null;
        ObjectMapper mapper = MantaObjectMapper.INSTANCE;
        if (entity != null && (responseContentType == null || responseContentType.getMimeType().equals(jsonContentType.getMimeType()))) {
            byte[] jsonBytes = new byte[]{};
            try (InputStream jsonStream = entity.getContent();){
                jsonBytes = IOUtils.toByteArray((InputStream)jsonStream);
                errorDetail = (ErrorDetail)mapper.readValue(jsonBytes, ErrorDetail.class);
            }
            catch (JsonProcessingException | RuntimeException e) {
                String json = new String(jsonBytes, StandardCharsets.UTF_8);
                String msg = String.format("Unable to deserialize json error data. Actual response:\n%s", json);
                LOGGER.warn(msg, e);
            }
            catch (IOException e) {
                LOGGER.warn("Problem getting response error content", (Throwable)e);
            }
        }
        this.setRequestId(HttpHelper.extractRequestId(response));
        this.setStatusLine(response.getStatusLine());
        if (errorDetail == null) {
            this.setServerCode(MantaErrorCode.NO_CODE_ERROR);
        } else {
            this.setServerCode(MantaErrorCode.valueOfCode(errorDetail.getCode()));
            this.setContextValue("server_message", errorDetail.getMessage());
        }
        HttpHelper.annotateContextedException(this, request, response);
        try {
            Header[] responseHeaders = response.getAllHeaders();
            if (responseHeaders != null) {
                this.setHeaders(new MantaHttpHeaders(responseHeaders));
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error setting response headers on exception", (Throwable)e);
        }
    }

    private static String buildExceptionMessageFromHttpExchange(HttpRequest request, HttpResponse response, String path, int ... expectedResponseCodes) {
        if (expectedResponseCodes != null) {
            return String.format("HTTP request returned unexpected response code: expected one of %s, got [%d] ", Arrays.toString(expectedResponseCodes), response.getStatusLine().getStatusCode());
        }
        return String.format("HTTP request failed to: %s", path);
    }

    @Deprecated
    public final boolean isSuccessStatusCode() {
        int code = this.getStatusCode();
        return code >= 200 && code < 400;
    }

    public final int getStatusCode() {
        if (this.statusLine != null) {
            return this.statusLine.getStatusCode();
        }
        return 0;
    }

    public final String getStatusMessage() {
        if (this.statusLine != null) {
            return this.statusLine.getReasonPhrase();
        }
        return null;
    }

    public final MantaHttpHeaders getHeaders() {
        return this.headers;
    }

    public String getContent() {
        return this.content;
    }

    public MantaErrorCode getServerCode() {
        return this.serverCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public MantaClientHttpResponseException setRequestId(String requestId) {
        this.requestId = requestId;
        this.setContextValue("requestId", requestId);
        return this;
    }

    public MantaClientHttpResponseException setStatusLine(StatusLine statusLine) {
        this.statusLine = statusLine;
        this.setContextValue("statusLine", statusLine);
        return this;
    }

    public MantaClientHttpResponseException setHeaders(MantaHttpHeaders headers) {
        this.headers = headers;
        this.setContextValue("headers", headers.toString());
        return this;
    }

    public MantaClientHttpResponseException setContent(String content) {
        this.content = content;
        this.setContextValue("content", content);
        return this;
    }

    public MantaClientHttpResponseException setServerCode(MantaErrorCode serverCode) {
        this.serverCode = serverCode;
        this.setContextValue("serverCode", serverCode.getCode());
        return this;
    }
}

