/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import com.joyent.manta.config.MetricReporterMode;
import com.joyent.manta.util.MantaUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;

public interface SettableConfigContext<T>
extends ConfigContext {
    public T setMantaURL(String var1);

    public T setMantaUser(String var1);

    public T setMantaKeyId(String var1);

    public T setMantaKeyPath(String var1);

    public T setTimeout(Integer var1);

    public T setRetries(Integer var1);

    public T setMaximumConnections(Integer var1);

    public T setPrivateKeyContent(String var1);

    public T setPassword(String var1);

    public T setHttpBufferSize(Integer var1);

    public T setHttpsProtocols(String var1);

    public T setHttpsCipherSuites(String var1);

    public T setNoAuth(Boolean var1);

    public T setDisableNativeSignatures(Boolean var1);

    public T setTcpSocketTimeout(Integer var1);

    public T setConnectionRequestTimeout(Integer var1);

    public T setExpectContinueTimeout(Integer var1);

    public T setVerifyUploads(Boolean var1);

    public T setUploadBufferSize(Integer var1);

    public T setSkipDirectoryDepth(Integer var1);

    public T setDownloadContinuations(Integer var1);

    public T setMetricReporterMode(MetricReporterMode var1);

    public T setMetricReporterOutputInterval(Integer var1);

    public T setClientEncryptionEnabled(Boolean var1);

    public T setEncryptionKeyId(String var1);

    public T setEncryptionAlgorithm(String var1);

    public T setPermitUnencryptedDownloads(Boolean var1);

    public T setEncryptionAuthenticationMode(EncryptionAuthenticationMode var1);

    public T setEncryptionPrivateKeyPath(String var1);

    public T setEncryptionPrivateKeyBytes(byte[] var1);

    public static void setAttributeFromContext(String name, Object value, SettableConfigContext<?> config) {
        switch (name) {
            case "manta.url": 
            case "MANTA_URL": {
                config.setMantaURL(Objects.toString(value));
                break;
            }
            case "manta.user": 
            case "MANTA_USER": {
                config.setMantaUser(Objects.toString(value));
                break;
            }
            case "manta.key_id": 
            case "MANTA_KEY_ID": {
                config.setMantaKeyId(Objects.toString(value));
                break;
            }
            case "manta.key_path": 
            case "MANTA_KEY_PATH": {
                config.setMantaKeyPath(Objects.toString(value));
                break;
            }
            case "manta.timeout": 
            case "MANTA_TIMEOUT": {
                config.setTimeout(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "manta.retries": 
            case "MANTA_HTTP_RETRIES": {
                config.setRetries(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "manta.max_connections": 
            case "MANTA_MAX_CONNS": {
                config.setMaximumConnections(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "manta.key_content": 
            case "MANTA_KEY_CONTENT": {
                config.setPrivateKeyContent(Objects.toString(value));
                break;
            }
            case "manta.password": 
            case "MANTA_PASSWORD": {
                config.setPassword(Objects.toString(value));
                break;
            }
            case "manta.http_buffer_size": 
            case "MANTA_HTTP_BUFFER_SIZE": {
                config.setHttpBufferSize(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "https.protocols": 
            case "MANTA_HTTPS_PROTOCOLS": {
                config.setHttpsProtocols(Objects.toString(value));
                break;
            }
            case "https.cipherSuites": 
            case "MANTA_HTTPS_CIPHERS": {
                config.setHttpsCipherSuites(Objects.toString(value));
                break;
            }
            case "manta.no_auth": 
            case "MANTA_NO_AUTH": {
                config.setNoAuth(MantaUtils.parseBooleanOrNull(value));
                break;
            }
            case "manta.disable_native_sigs": 
            case "MANTA_NO_NATIVE_SIGS": {
                config.disableNativeSignatures();
                break;
            }
            case "manta.tcp_socket_timeout": 
            case "MANTA_TCP_SOCKET_TIMEOUT": {
                config.setTcpSocketTimeout(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "manta.upload_buffer_size": 
            case "MANTA_UPLOAD_BUFFER_SIZE": {
                config.setUploadBufferSize(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "manta.skip_directory_depth": 
            case "MANTA_SKIP_DIRECTORY_DEPTH": {
                config.setSkipDirectoryDepth(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "manta.metric_reporter.mode": 
            case "MANTA_METRIC_REPORTER_MODE": {
                String metricReporterModeStr = Objects.toString(value);
                if (StringUtils.isBlank((CharSequence)metricReporterModeStr)) {
                    return;
                }
                try {
                    config.setEncryptionAuthenticationMode(EncryptionAuthenticationMode.valueOf(metricReporterModeStr));
                    break;
                }
                catch (IllegalArgumentException e) {
                    return;
                }
            }
            case "manta.metric_reporter.output_interval": 
            case "MANTA_METRIC_REPORTER_OUTPUT_INTERVAL": {
                config.setMetricReporterOutputInterval(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "manta.client_encryption": 
            case "MANTA_CLIENT_ENCRYPTION": {
                config.setClientEncryptionEnabled(MantaUtils.parseBooleanOrNull(value));
                break;
            }
            case "manta.connection_request_timeout": 
            case "MANTA_CONNECTION_REQUEST_TIMEOUT": {
                config.setConnectionRequestTimeout(MantaUtils.parseIntegerOrNull(value));
                break;
            }
            case "manta.encryption_key_id": 
            case "MANTA_CLIENT_ENCRYPTION_KEY_ID": {
                config.setEncryptionKeyId(Objects.toString(value));
                break;
            }
            case "manta.permit_unencrypted_downloads": 
            case "MANTA_UNENCRYPTED_DOWNLOADS": {
                config.setPermitUnencryptedDownloads(MantaUtils.parseBooleanOrNull(value));
                break;
            }
            case "manta.encryption_auth_mode": 
            case "MANTA_ENCRYPTION_AUTH_MODE": {
                String stringVal = Objects.toString(value);
                if (StringUtils.isBlank((CharSequence)stringVal)) {
                    return;
                }
                try {
                    config.setEncryptionAuthenticationMode(EncryptionAuthenticationMode.valueOf(stringVal));
                    break;
                }
                catch (IllegalArgumentException e) {
                    return;
                }
            }
            case "manta.encryption_key_path": 
            case "MANTA_ENCRYPTION_KEY_PATH": {
                config.setEncryptionPrivateKeyPath(Objects.toString(value));
                break;
            }
            case "manta.encryption_key_bytes": {
                if (!(value instanceof byte[])) break;
                config.setEncryptionPrivateKeyBytes((byte[])value);
                break;
            }
            case "manta.encryption_key_bytes_base64": 
            case "MANTA_ENCRYPTION_KEY_BYTES": {
                if (!(value instanceof String)) break;
                String base64 = (String)value;
                if (StringUtils.isEmpty((CharSequence)base64)) {
                    return;
                }
                config.setEncryptionPrivateKeyBytes(Base64.decode((String)base64));
                break;
            }
        }
    }
}

