/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.multipart.MultipartOutputStream;
import com.joyent.manta.http.MantaContentTypes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

public class EncryptingPartEntity
implements HttpEntity {
    public static final long UNKNOWN_LENGTH = -1L;
    private static final Header CRYPTO_TRANSFER_ENCODING = null;
    private static final Header CRYPTO_CONTENT_TYPE = new BasicHeader("Content-Type", MantaContentTypes.ENCRYPTED_OBJECT.toString());
    private static final int BUFFER_SIZE = 128;
    private final OutputStream cipherStream;
    private final HttpEntity wrapped;
    private final MultipartOutputStream multipartStream;
    private final LastPartCallback lastPartCallback;

    public EncryptingPartEntity(OutputStream cipherStream, MultipartOutputStream multipartStream, HttpEntity wrapped, LastPartCallback lastPartCallback) {
        this.cipherStream = cipherStream;
        this.multipartStream = multipartStream;
        this.wrapped = wrapped;
        this.lastPartCallback = lastPartCallback;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return true;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentType() {
        return CRYPTO_CONTENT_TYPE;
    }

    public Header getContentEncoding() {
        return CRYPTO_TRANSFER_ENCODING;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.wrapped.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream httpOut) throws IOException {
        Validate.notNull((Object)httpOut, (String)"HttpOut stream must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)this.multipartStream, (String)"MultipartStream must not be null", (Object[])new Object[0]);
        this.multipartStream.setNext(httpOut);
        InputStream contentStream = this.getContent();
        Validate.notNull((Object)contentStream, (String)"Content input stream must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)this.cipherStream, (String)"Cipher output stream must not be null", (Object[])new Object[0]);
        CountingOutputStream cout = new CountingOutputStream(this.cipherStream);
        try {
            ByteArrayOutputStream remainderStream;
            IOUtils.copy((InputStream)contentStream, (OutputStream)cout, (int)128);
            this.cipherStream.flush();
            if (this.lastPartCallback != null && (remainderStream = this.lastPartCallback.call(cout.getByteCount())).size() > 0) {
                IOUtils.copy((InputStream)new ByteArrayInputStream(remainderStream.toByteArray()), (OutputStream)httpOut, (int)128);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    public boolean isStreaming() {
        return this.wrapped.isStreaming();
    }

    public void consumeContent() throws IOException {
        this.wrapped.consumeContent();
    }

    public static abstract class LastPartCallback {
        public abstract ByteArrayOutputStream call(long var1) throws IOException;
    }
}

