/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.analytics.AnalyticsProvider;
import ch.cyberduck.core.analytics.QloudstatAnalyticsProvider;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.openstack.SwiftAccountLoader;
import ch.cyberduck.core.openstack.SwiftAttributesFinderFeature;
import ch.cyberduck.core.openstack.SwiftAuthenticationService;
import ch.cyberduck.core.openstack.SwiftCopyFeature;
import ch.cyberduck.core.openstack.SwiftDirectoryFeature;
import ch.cyberduck.core.openstack.SwiftDistributionConfiguration;
import ch.cyberduck.core.openstack.SwiftDistributionConfigurationLoader;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftFindFeature;
import ch.cyberduck.core.openstack.SwiftHomeFinderService;
import ch.cyberduck.core.openstack.SwiftLargeUploadWriteFeature;
import ch.cyberduck.core.openstack.SwiftListService;
import ch.cyberduck.core.openstack.SwiftLocationFeature;
import ch.cyberduck.core.openstack.SwiftMetadataFeature;
import ch.cyberduck.core.openstack.SwiftMoveFeature;
import ch.cyberduck.core.openstack.SwiftMultipleDeleteFeature;
import ch.cyberduck.core.openstack.SwiftReadFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftThresholdUploadService;
import ch.cyberduck.core.openstack.SwiftTouchFeature;
import ch.cyberduck.core.openstack.SwiftUrlProvider;
import ch.cyberduck.core.openstack.SwiftWriteFeature;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.shared.DelegatingSchedulerFeature;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.method.AuthenticationRequest;
import ch.iterate.openstack.swift.model.AccountInfo;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class SwiftSession
extends HttpSession<Client> {
    private static final Logger log = Logger.getLogger(SwiftSession.class);
    private final SwiftRegionService regionService = new SwiftRegionService(this);
    private Map<Region, AccountInfo> accounts = Collections.emptyMap();
    private Map<Path, Distribution> distributions = Collections.emptyMap();

    public SwiftSession(Host host) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname()), (X509KeyManager)new DefaultX509KeyManager());
    }

    public SwiftSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    public Client connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) throws BackgroundException {
        HttpClientBuilder pool = this.builder.build(proxy, (TranscriptListener)this, prompt);
        pool.disableContentCompression();
        return new Client(pool.build());
    }

    protected void logout() throws BackgroundException {
        try {
            ((Client)this.client).disconnect();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        try {
            Set<? extends AuthenticationRequest> options = new SwiftAuthenticationService().getRequest(this.host, prompt);
            Iterator<? extends AuthenticationRequest> iter = options.iterator();
            while (iter.hasNext()) {
                try {
                    AuthenticationRequest auth = iter.next();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Attempt authentication with %s", auth));
                    }
                    ((Client)this.client).authenticate(auth);
                    break;
                }
                catch (GenericException failure) {
                    BackgroundException reason = new SwiftExceptionMappingService().map(failure);
                    if (reason instanceof LoginFailureException || reason instanceof AccessDeniedException || reason instanceof InteroperabilityException) {
                        if (!iter.hasNext()) {
                            throw failure;
                        }
                    } else {
                        throw failure;
                    }
                    cancel.verify();
                }
            }
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SwiftListService(this, this.regionService);
        }
        if (type == Read.class) {
            return (T)new SwiftReadFeature(this, this.regionService);
        }
        if (type == MultipartWrite.class) {
            return (T)new SwiftLargeUploadWriteFeature(this, this.regionService, new SwiftSegmentService(this, this.regionService));
        }
        if (type == Write.class) {
            return (T)((Object)new SwiftWriteFeature(this, this.regionService));
        }
        if (type == Upload.class) {
            return (T)new SwiftThresholdUploadService(this, this.regionService, new SwiftWriteFeature(this, this.regionService));
        }
        if (type == Directory.class) {
            return (T)new SwiftDirectoryFeature(this, this.regionService, new SwiftWriteFeature(this, this.regionService));
        }
        if (type == Delete.class) {
            return (T)new SwiftMultipleDeleteFeature(this, new SwiftSegmentService(this, this.regionService), this.regionService);
        }
        if (type == Headers.class) {
            return (T)new SwiftMetadataFeature(this, this.regionService);
        }
        if (type == Metadata.class) {
            return (T)new SwiftMetadataFeature(this, this.regionService);
        }
        if (type == Copy.class) {
            return (T)new SwiftCopyFeature(this, this.regionService);
        }
        if (type == Move.class) {
            return (T)new SwiftMoveFeature(this, this.regionService);
        }
        if (type == Touch.class) {
            return (T)new SwiftTouchFeature(this, this.regionService);
        }
        if (type == Location.class) {
            return (T)new SwiftLocationFeature(this);
        }
        if (type == AnalyticsProvider.class) {
            return (T)new QloudstatAnalyticsProvider();
        }
        if (type == DistributionConfiguration.class) {
            for (Region region : this.accounts.keySet()) {
                if (null != region.getCDNManagementUrl()) continue;
                log.warn((Object)String.format("Missing CDN Management URL for region %s", region.getRegionId()));
                return null;
            }
            return (T)new SwiftDistributionConfiguration(this, this.distributions, this.regionService);
        }
        if (type == UrlProvider.class) {
            return (T)new SwiftUrlProvider(this, this.accounts, this.regionService);
        }
        if (type == Find.class) {
            return (T)new SwiftFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new SwiftAttributesFinderFeature(this, this.regionService);
        }
        if (type == Home.class) {
            return (T)((Object)new SwiftHomeFinderService(this));
        }
        if (type == Scheduler.class) {
            return (T)new DelegatingSchedulerFeature(new Scheduler[]{new SwiftAccountLoader(this){

                @Override
                public Map<Region, AccountInfo> operate(PasswordCallback callback, Path container) throws BackgroundException {
                    return SwiftSession.this.accounts = (Map)super.operate(callback, container);
                }
            }, new SwiftDistributionConfigurationLoader(this){

                @Override
                public Map<Path, Distribution> operate(PasswordCallback callback, Path container) throws BackgroundException {
                    return SwiftSession.this.distributions = (Map)super.operate(callback, container);
                }
            }});
        }
        return (T)super._getFeature(type);
    }
}

