/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.sds.SDSNodeIdProvider;

public class SDSFindFeature
implements Find {
    private final SDSNodeIdProvider nodeid;
    private Cache<Path> cache = PathCache.empty();

    public SDSFindFeature(SDSNodeIdProvider nodeid) {
        this.nodeid = nodeid;
    }

    public boolean find(Path file) throws BackgroundException {
        try {
            this.nodeid.withCache((Cache)this.cache).getFileid(file, (ListProgressListener)new DisabledListProgressListener());
            return true;
        }
        catch (NotfoundException e) {
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

